/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Request
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="path")
    public String path;
    @JsonProperty(value="source")
    public String source;
    @JsonProperty(value="destination")
    public String destination;
    @JsonProperty(value="automation_id")
    public Long automationId;
    @JsonProperty(value="user_display_name")
    public String userDisplayName;
    @JsonProperty(value="user_ids")
    public String userIds;
    @JsonProperty(value="group_ids")
    public String groupIds;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public Request() {
        this(null, null);
    }

    public Request(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public Request(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public Long getAutomationId() {
        return this.automationId;
    }

    public void setAutomationId(Long automationId) {
        this.automationId = automationId;
    }

    public String getUserDisplayName() {
        return this.userDisplayName;
    }

    public void setUserDisplayName(String userDisplayName) {
        this.userDisplayName = userDisplayName;
    }

    public String getUserIds() {
        return this.userIds;
    }

    public void setUserIds(String userIds) {
        this.userIds = userIds;
    }

    public String getGroupIds() {
        return this.groupIds;
    }

    public void setGroupIds(String groupIds) {
        this.groupIds = groupIds;
    }

    public void delete(HashMap<String, Object> parameters) throws IOException {
        Request.delete(this.id, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete(parameters);
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        Request.create(parameters, this.options);
    }

    public static ListIterator<Request> list() throws RuntimeException {
        return Request.list(null, null);
    }

    public static ListIterator<Request> list(HashMap<String, Object> parameters) throws RuntimeException {
        return Request.list(parameters, null);
    }

    public static ListIterator<Request> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("mine") && !(parameters.get("mine") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: mine must be of type Boolean parameters[\"mine\"]");
        }
        if (parameters.containsKey("path") && !(parameters.get("path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        String url = String.format("%s%s/requests", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<Request>> typeReference = new TypeReference<List<Request>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<Request> all() throws RuntimeException {
        return Request.all(null, null);
    }

    public static ListIterator<Request> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Request.list(parameters, options);
    }

    public static Request getFolder() throws RuntimeException {
        return Request.getFolder(null, null, null);
    }

    public static Request getFolder(String path, HashMap<String, Object> parameters) throws RuntimeException {
        return Request.getFolder(path, parameters, null);
    }

    public static Request getFolder(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Request.getFolder(null, parameters, options);
    }

    public static Request getFolder(String path, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (path == null && parameters.containsKey("path") && parameters.get("path") != null) {
            path = (String)parameters.get("path");
        }
        if (path == null) {
            throw new NullPointerException("Argument or Parameter missing: path parameters[\"path\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("mine") && !(parameters.get("mine") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: mine must be of type Boolean parameters[\"mine\"]");
        }
        if (!(path instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), path};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/requests/folders/%s", urlParts);
        TypeReference<Request> typeReference = new TypeReference<Request>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static Request create() throws RuntimeException {
        return Request.create(null, null);
    }

    public static Request create(HashMap<String, Object> parameters) throws RuntimeException {
        return Request.create(parameters, null);
    }

    public static Request create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("path") || parameters.get("path") == null) {
            throw new NullPointerException("Parameter missing: path parameters[\"path\"]");
        }
        if (!parameters.containsKey("destination") || parameters.get("destination") == null) {
            throw new NullPointerException("Parameter missing: destination parameters[\"destination\"]");
        }
        if (parameters.containsKey("path") && !(parameters.get("path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: path must be of type String parameters[\"path\"]");
        }
        if (parameters.containsKey("destination") && !(parameters.get("destination") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: destination must be of type String parameters[\"destination\"]");
        }
        if (parameters.containsKey("user_ids") && !(parameters.get("user_ids") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: user_ids must be of type String parameters[\"user_ids\"]");
        }
        if (parameters.containsKey("group_ids") && !(parameters.get("group_ids") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: group_ids must be of type String parameters[\"group_ids\"]");
        }
        String url = String.format("%s%s/requests", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<Request> typeReference = new TypeReference<Request>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static void delete() throws RuntimeException {
        Request.delete(null, null, null);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        Request.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Request.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/requests/%s", urlParts);
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        Request.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Request.delete(id, parameters, options);
    }
}

