/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import com.files.util.UrlUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GpgKey
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="expires_at")
    public Date expiresAt;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="partner_id")
    public Long partnerId;
    @JsonProperty(value="user_id")
    public Long userId;
    @JsonProperty(value="public_key_md5")
    public String publicKeyMd5;
    @JsonProperty(value="private_key_md5")
    public String privateKeyMd5;
    @JsonProperty(value="generated_public_key")
    public String generatedPublicKey;
    @JsonProperty(value="generated_private_key")
    public String generatedPrivateKey;
    @JsonProperty(value="private_key_password_md5")
    public String privateKeyPasswordMd5;
    @JsonProperty(value="public_key")
    public String publicKey;
    @JsonProperty(value="private_key")
    public String privateKey;
    @JsonProperty(value="private_key_password")
    public String privateKeyPassword;
    @JsonProperty(value="generate_expires_at")
    public String generateExpiresAt;
    @JsonProperty(value="generate_keypair")
    public Boolean generateKeypair;
    @JsonProperty(value="generate_full_name")
    public String generateFullName;
    @JsonProperty(value="generate_email")
    public String generateEmail;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public GpgKey() {
        this(null, null);
    }

    public GpgKey(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public GpgKey(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(Date expiresAt) {
        this.expiresAt = expiresAt;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getPartnerId() {
        return this.partnerId;
    }

    public void setPartnerId(Long partnerId) {
        this.partnerId = partnerId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getPublicKeyMd5() {
        return this.publicKeyMd5;
    }

    public void setPublicKeyMd5(String publicKeyMd5) {
        this.publicKeyMd5 = publicKeyMd5;
    }

    public String getPrivateKeyMd5() {
        return this.privateKeyMd5;
    }

    public void setPrivateKeyMd5(String privateKeyMd5) {
        this.privateKeyMd5 = privateKeyMd5;
    }

    public String getGeneratedPublicKey() {
        return this.generatedPublicKey;
    }

    public void setGeneratedPublicKey(String generatedPublicKey) {
        this.generatedPublicKey = generatedPublicKey;
    }

    public String getGeneratedPrivateKey() {
        return this.generatedPrivateKey;
    }

    public void setGeneratedPrivateKey(String generatedPrivateKey) {
        this.generatedPrivateKey = generatedPrivateKey;
    }

    public String getPrivateKeyPasswordMd5() {
        return this.privateKeyPasswordMd5;
    }

    public void setPrivateKeyPasswordMd5(String privateKeyPasswordMd5) {
        this.privateKeyPasswordMd5 = privateKeyPasswordMd5;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getPrivateKeyPassword() {
        return this.privateKeyPassword;
    }

    public void setPrivateKeyPassword(String privateKeyPassword) {
        this.privateKeyPassword = privateKeyPassword;
    }

    public String getGenerateExpiresAt() {
        return this.generateExpiresAt;
    }

    public void setGenerateExpiresAt(String generateExpiresAt) {
        this.generateExpiresAt = generateExpiresAt;
    }

    public Boolean getGenerateKeypair() {
        return this.generateKeypair;
    }

    public void setGenerateKeypair(Boolean generateKeypair) {
        this.generateKeypair = generateKeypair;
    }

    public String getGenerateFullName() {
        return this.generateFullName;
    }

    public void setGenerateFullName(String generateFullName) {
        this.generateFullName = generateFullName;
    }

    public String getGenerateEmail() {
        return this.generateEmail;
    }

    public void setGenerateEmail(String generateEmail) {
        this.generateEmail = generateEmail;
    }

    public GpgKey update(HashMap<String, Object> parameters) throws IOException {
        return GpgKey.update(this.id, parameters, this.options);
    }

    public void delete(HashMap<String, Object> parameters) throws IOException {
        GpgKey.delete(this.id, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete(parameters);
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        GpgKey.create(parameters, this.options);
    }

    public static ListIterator<GpgKey> list() throws RuntimeException {
        return GpgKey.list(null, null);
    }

    public static ListIterator<GpgKey> list(HashMap<String, Object> parameters) throws RuntimeException {
        return GpgKey.list(parameters, null);
    }

    public static ListIterator<GpgKey> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long) && !(parameters.get("user_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long or Integer parameters[\"user_id\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        String url = String.format("%s%s/gpg_keys", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<GpgKey>> typeReference = new TypeReference<List<GpgKey>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<GpgKey> all() throws RuntimeException {
        return GpgKey.all(null, null);
    }

    public static ListIterator<GpgKey> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return GpgKey.list(parameters, options);
    }

    public static GpgKey find() throws RuntimeException {
        return GpgKey.find(null, null, null);
    }

    public static GpgKey find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return GpgKey.find(id, parameters, null);
    }

    public static GpgKey find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return GpgKey.find(null, parameters, options);
    }

    public static GpgKey find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        String url = String.format("%s%s/gpg_keys/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        TypeReference<GpgKey> typeReference = new TypeReference<GpgKey>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static GpgKey get() throws RuntimeException {
        return GpgKey.get(null, null, null);
    }

    public static GpgKey get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return GpgKey.find(id, parameters, options);
    }

    public static GpgKey create() throws RuntimeException {
        return GpgKey.create(null, null);
    }

    public static GpgKey create(HashMap<String, Object> parameters) throws RuntimeException {
        return GpgKey.create(parameters, null);
    }

    public static GpgKey create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("name") || parameters.get("name") == null) {
            throw new NullPointerException("Parameter missing: name parameters[\"name\"]");
        }
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long) && !(parameters.get("user_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long or Integer parameters[\"user_id\"]");
        }
        if (parameters.containsKey("partner_id") && !(parameters.get("partner_id") instanceof Long) && !(parameters.get("partner_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: partner_id must be of type Long or Integer parameters[\"partner_id\"]");
        }
        if (parameters.containsKey("public_key") && !(parameters.get("public_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: public_key must be of type String parameters[\"public_key\"]");
        }
        if (parameters.containsKey("private_key") && !(parameters.get("private_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: private_key must be of type String parameters[\"private_key\"]");
        }
        if (parameters.containsKey("private_key_password") && !(parameters.get("private_key_password") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: private_key_password must be of type String parameters[\"private_key_password\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("generate_expires_at") && !(parameters.get("generate_expires_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: generate_expires_at must be of type String parameters[\"generate_expires_at\"]");
        }
        if (parameters.containsKey("generate_keypair") && !(parameters.get("generate_keypair") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: generate_keypair must be of type Boolean parameters[\"generate_keypair\"]");
        }
        if (parameters.containsKey("generate_full_name") && !(parameters.get("generate_full_name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: generate_full_name must be of type String parameters[\"generate_full_name\"]");
        }
        if (parameters.containsKey("generate_email") && !(parameters.get("generate_email") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: generate_email must be of type String parameters[\"generate_email\"]");
        }
        String url = String.format("%s%s/gpg_keys", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<GpgKey> typeReference = new TypeReference<GpgKey>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static GpgKey update() throws RuntimeException {
        return GpgKey.update(null, null, null);
    }

    public static GpgKey update(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return GpgKey.update(id, parameters, null);
    }

    public static GpgKey update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return GpgKey.update(null, parameters, options);
    }

    public static GpgKey update(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        if (parameters.containsKey("partner_id") && !(parameters.get("partner_id") instanceof Long) && !(parameters.get("partner_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: partner_id must be of type Long or Integer parameters[\"partner_id\"]");
        }
        if (parameters.containsKey("public_key") && !(parameters.get("public_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: public_key must be of type String parameters[\"public_key\"]");
        }
        if (parameters.containsKey("private_key") && !(parameters.get("private_key") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: private_key must be of type String parameters[\"private_key\"]");
        }
        if (parameters.containsKey("private_key_password") && !(parameters.get("private_key_password") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: private_key_password must be of type String parameters[\"private_key_password\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        String url = String.format("%s%s/gpg_keys/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        TypeReference<GpgKey> typeReference = new TypeReference<GpgKey>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete() throws RuntimeException {
        GpgKey.delete(null, null, null);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        GpgKey.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        GpgKey.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        String url = String.format("%s%s/gpg_keys/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        GpgKey.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        GpgKey.delete(id, parameters, options);
    }
}

