/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import com.files.util.UrlUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Partner
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="allow_bypassing_2fa_policies")
    public Boolean allowBypassing2faPolicies;
    @JsonProperty(value="allow_credential_changes")
    public Boolean allowCredentialChanges;
    @JsonProperty(value="allow_user_creation")
    public Boolean allowUserCreation;
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="notes")
    public String notes;
    @JsonProperty(value="root_folder")
    public String rootFolder;
    @JsonProperty(value="tags")
    public String tags;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public Partner() {
        this(null, null);
    }

    public Partner(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public Partner(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Boolean getAllowBypassing2faPolicies() {
        return this.allowBypassing2faPolicies;
    }

    public void setAllowBypassing2faPolicies(Boolean allowBypassing2faPolicies) {
        this.allowBypassing2faPolicies = allowBypassing2faPolicies;
    }

    public Boolean getAllowCredentialChanges() {
        return this.allowCredentialChanges;
    }

    public void setAllowCredentialChanges(Boolean allowCredentialChanges) {
        this.allowCredentialChanges = allowCredentialChanges;
    }

    public Boolean getAllowUserCreation() {
        return this.allowUserCreation;
    }

    public void setAllowUserCreation(Boolean allowUserCreation) {
        this.allowUserCreation = allowUserCreation;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getRootFolder() {
        return this.rootFolder;
    }

    public void setRootFolder(String rootFolder) {
        this.rootFolder = rootFolder;
    }

    public String getTags() {
        return this.tags;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public Partner update(HashMap<String, Object> parameters) throws IOException {
        return Partner.update(this.id, parameters, this.options);
    }

    public void delete(HashMap<String, Object> parameters) throws IOException {
        Partner.delete(this.id, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete(parameters);
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        Partner.create(parameters, this.options);
    }

    public static ListIterator<Partner> list() throws RuntimeException {
        return Partner.list(null, null);
    }

    public static ListIterator<Partner> list(HashMap<String, Object> parameters) throws RuntimeException {
        return Partner.list(parameters, null);
    }

    public static ListIterator<Partner> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        String url = String.format("%s%s/partners", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<Partner>> typeReference = new TypeReference<List<Partner>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<Partner> all() throws RuntimeException {
        return Partner.all(null, null);
    }

    public static ListIterator<Partner> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Partner.list(parameters, options);
    }

    public static Partner find() throws RuntimeException {
        return Partner.find(null, null, null);
    }

    public static Partner find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return Partner.find(id, parameters, null);
    }

    public static Partner find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Partner.find(null, parameters, options);
    }

    public static Partner find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        String url = String.format("%s%s/partners/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        TypeReference<Partner> typeReference = new TypeReference<Partner>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static Partner get() throws RuntimeException {
        return Partner.get(null, null, null);
    }

    public static Partner get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Partner.find(id, parameters, options);
    }

    public static Partner create() throws RuntimeException {
        return Partner.create(null, null);
    }

    public static Partner create(HashMap<String, Object> parameters) throws RuntimeException {
        return Partner.create(parameters, null);
    }

    public static Partner create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("allow_bypassing_2fa_policies") && !(parameters.get("allow_bypassing_2fa_policies") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: allow_bypassing_2fa_policies must be of type Boolean parameters[\"allow_bypassing_2fa_policies\"]");
        }
        if (parameters.containsKey("allow_credential_changes") && !(parameters.get("allow_credential_changes") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: allow_credential_changes must be of type Boolean parameters[\"allow_credential_changes\"]");
        }
        if (parameters.containsKey("allow_user_creation") && !(parameters.get("allow_user_creation") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: allow_user_creation must be of type Boolean parameters[\"allow_user_creation\"]");
        }
        if (parameters.containsKey("notes") && !(parameters.get("notes") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: notes must be of type String parameters[\"notes\"]");
        }
        if (parameters.containsKey("root_folder") && !(parameters.get("root_folder") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: root_folder must be of type String parameters[\"root_folder\"]");
        }
        if (parameters.containsKey("tags") && !(parameters.get("tags") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: tags must be of type String parameters[\"tags\"]");
        }
        String url = String.format("%s%s/partners", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<Partner> typeReference = new TypeReference<Partner>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static Partner update() throws RuntimeException {
        return Partner.update(null, null, null);
    }

    public static Partner update(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return Partner.update(id, parameters, null);
    }

    public static Partner update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return Partner.update(null, parameters, options);
    }

    public static Partner update(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("allow_bypassing_2fa_policies") && !(parameters.get("allow_bypassing_2fa_policies") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: allow_bypassing_2fa_policies must be of type Boolean parameters[\"allow_bypassing_2fa_policies\"]");
        }
        if (parameters.containsKey("allow_credential_changes") && !(parameters.get("allow_credential_changes") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: allow_credential_changes must be of type Boolean parameters[\"allow_credential_changes\"]");
        }
        if (parameters.containsKey("allow_user_creation") && !(parameters.get("allow_user_creation") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: allow_user_creation must be of type Boolean parameters[\"allow_user_creation\"]");
        }
        if (parameters.containsKey("notes") && !(parameters.get("notes") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: notes must be of type String parameters[\"notes\"]");
        }
        if (parameters.containsKey("root_folder") && !(parameters.get("root_folder") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: root_folder must be of type String parameters[\"root_folder\"]");
        }
        if (parameters.containsKey("tags") && !(parameters.get("tags") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: tags must be of type String parameters[\"tags\"]");
        }
        String url = String.format("%s%s/partners/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        TypeReference<Partner> typeReference = new TypeReference<Partner>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete() throws RuntimeException {
        Partner.delete(null, null, null);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        Partner.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Partner.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        String url = String.format("%s%s/partners/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        Partner.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        Partner.delete(id, parameters, options);
    }
}

