/*
 * Decompiled with CFR 0.152.
 */
package com.files.net;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesConfig;
import com.files.ResponseError;
import com.files.exceptions.ApiErrorException;
import com.files.exceptions.SdkException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilesHttpExecutor {
    private static final Logger log = LoggerFactory.getLogger(FilesHttpExecutor.class);
    private final CloseableHttpClient client;
    private final ObjectMapper objectMapper;
    private final FilesConfig config = FilesConfig.getInstance();

    public FilesHttpExecutor(CloseableHttpClient client) {
        this.client = client;
        this.objectMapper = ((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).build();
    }

    public HttpResponse executeWithRetry(HttpRequestBase request) throws IOException {
        Throwable lastException = null;
        for (int attempts = 0; attempts < this.config.getUpstreamMaxAttempts(); ++attempts) {
            try {
                CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 429 || statusCode >= 502) {
                    log.warn(String.format("Retrying due to HTTP status %d (attempt %d)", statusCode, attempts));
                    lastException = this.mapApiError((HttpResponse)response, statusCode);
                    this.backoff(attempts);
                    continue;
                }
                if (statusCode >= 400) {
                    throw this.mapApiError((HttpResponse)response, statusCode);
                }
                return response;
            }
            catch (IOException e) {
                log.warn(String.format("IOException on attempt %d: %s", attempts, e.getMessage()));
                lastException = e;
                if (attempts >= this.config.getUpstreamMaxAttempts()) break;
                this.backoff(attempts);
                continue;
            }
        }
        if (lastException instanceof SdkException) {
            throw (SdkException)lastException;
        }
        throw new ApiErrorException.ApiConnectionException(lastException.getMessage());
    }

    private void backoff(int attempt) {
        try {
            long delay = (long)Math.pow(2.0, attempt - 1) * (long)this.config.getInitialRetryDelayMillis();
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ApiErrorException.ApiConnectionException("Request interrupted during backoff");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SdkException mapApiError(HttpResponse response, int statusCode) throws IOException {
        String message = "HTTP returned status " + statusCode;
        String body = null;
        ResponseError responseError = new ResponseError();
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                body = EntityUtils.toString((HttpEntity)entity);
                responseError = (ResponseError)this.objectMapper.readValue(body, ResponseError.class);
            }
        }
        catch (JsonProcessingException e) {
            if (statusCode >= 500) {
                ApiErrorException.ServerErrorException serverErrorException = new ApiErrorException.ServerErrorException(body);
                return serverErrorException;
            }
            if (statusCode == 403) {
                ApiErrorException.AuthenticationException authenticationException = new ApiErrorException.AuthenticationException(body, Arrays.asList(response.getAllHeaders()));
                return authenticationException;
            }
            ApiErrorException.InvalidResponseException invalidResponseException = new ApiErrorException.InvalidResponseException(e.getMessage());
            return invalidResponseException;
        }
        catch (IOException e) {
            ApiErrorException.InvalidResponseException invalidResponseException = new ApiErrorException.InvalidResponseException(e.getMessage());
            return invalidResponseException;
        }
        finally {
            this.consumeQuietly(response);
        }
        return ApiErrorException.forType(message, responseError, Arrays.asList(response.getAllHeaders()));
    }

    private void consumeQuietly(HttpResponse response) {
        try {
            if (response.getEntity() != null) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

