/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ActionNotificationExport
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="export_version")
    public String exportVersion;
    @JsonProperty(value="start_at")
    public Date startAt;
    @JsonProperty(value="end_at")
    public Date endAt;
    @JsonProperty(value="status")
    public String status;
    @JsonProperty(value="query_path")
    public String queryPath;
    @JsonProperty(value="query_folder")
    public String queryFolder;
    @JsonProperty(value="query_message")
    public String queryMessage;
    @JsonProperty(value="query_request_method")
    public String queryRequestMethod;
    @JsonProperty(value="query_request_url")
    public String queryRequestUrl;
    @JsonProperty(value="query_status")
    public String queryStatus;
    @JsonProperty(value="query_success")
    public Boolean querySuccess;
    @JsonProperty(value="results_url")
    public String resultsUrl;
    @JsonProperty(value="user_id")
    public Long userId;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public ActionNotificationExport() {
        this(null, null);
    }

    public ActionNotificationExport(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public ActionNotificationExport(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getExportVersion() {
        return this.exportVersion;
    }

    public void setExportVersion(String exportVersion) {
        this.exportVersion = exportVersion;
    }

    public Date getStartAt() {
        return this.startAt;
    }

    public void setStartAt(Date startAt) {
        this.startAt = startAt;
    }

    public Date getEndAt() {
        return this.endAt;
    }

    public void setEndAt(Date endAt) {
        this.endAt = endAt;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getQueryPath() {
        return this.queryPath;
    }

    public void setQueryPath(String queryPath) {
        this.queryPath = queryPath;
    }

    public String getQueryFolder() {
        return this.queryFolder;
    }

    public void setQueryFolder(String queryFolder) {
        this.queryFolder = queryFolder;
    }

    public String getQueryMessage() {
        return this.queryMessage;
    }

    public void setQueryMessage(String queryMessage) {
        this.queryMessage = queryMessage;
    }

    public String getQueryRequestMethod() {
        return this.queryRequestMethod;
    }

    public void setQueryRequestMethod(String queryRequestMethod) {
        this.queryRequestMethod = queryRequestMethod;
    }

    public String getQueryRequestUrl() {
        return this.queryRequestUrl;
    }

    public void setQueryRequestUrl(String queryRequestUrl) {
        this.queryRequestUrl = queryRequestUrl;
    }

    public String getQueryStatus() {
        return this.queryStatus;
    }

    public void setQueryStatus(String queryStatus) {
        this.queryStatus = queryStatus;
    }

    public Boolean getQuerySuccess() {
        return this.querySuccess;
    }

    public void setQuerySuccess(Boolean querySuccess) {
        this.querySuccess = querySuccess;
    }

    public String getResultsUrl() {
        return this.resultsUrl;
    }

    public void setResultsUrl(String resultsUrl) {
        this.resultsUrl = resultsUrl;
    }

    public Long getUserId() {
        return this.userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        ActionNotificationExport.create(parameters, this.options);
    }

    public static ActionNotificationExport find() throws RuntimeException {
        return ActionNotificationExport.find(null, null, null);
    }

    public static ActionNotificationExport find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return ActionNotificationExport.find(id, parameters, null);
    }

    public static ActionNotificationExport find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return ActionNotificationExport.find(null, parameters, options);
    }

    public static ActionNotificationExport find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        Object[] urlParts = new String[]{FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), String.valueOf(id)};
        for (int i = 2; i < urlParts.length; ++i) {
            try {
                urlParts[i] = new URI(null, null, (String)urlParts[i], null).getRawPath();
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        String url = String.format("%s%s/action_notification_exports/%s", urlParts);
        TypeReference<ActionNotificationExport> typeReference = new TypeReference<ActionNotificationExport>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ActionNotificationExport get() throws RuntimeException {
        return ActionNotificationExport.get(null, null, null);
    }

    public static ActionNotificationExport get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return ActionNotificationExport.find(id, parameters, options);
    }

    public static ActionNotificationExport create() throws RuntimeException {
        return ActionNotificationExport.create(null, null);
    }

    public static ActionNotificationExport create(HashMap<String, Object> parameters) throws RuntimeException {
        return ActionNotificationExport.create(parameters, null);
    }

    public static ActionNotificationExport create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("user_id") && !(parameters.get("user_id") instanceof Long) && !(parameters.get("user_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: user_id must be of type Long or Integer parameters[\"user_id\"]");
        }
        if (parameters.containsKey("start_at") && !(parameters.get("start_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: start_at must be of type String parameters[\"start_at\"]");
        }
        if (parameters.containsKey("end_at") && !(parameters.get("end_at") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: end_at must be of type String parameters[\"end_at\"]");
        }
        if (parameters.containsKey("query_message") && !(parameters.get("query_message") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_message must be of type String parameters[\"query_message\"]");
        }
        if (parameters.containsKey("query_request_method") && !(parameters.get("query_request_method") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_request_method must be of type String parameters[\"query_request_method\"]");
        }
        if (parameters.containsKey("query_request_url") && !(parameters.get("query_request_url") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_request_url must be of type String parameters[\"query_request_url\"]");
        }
        if (parameters.containsKey("query_status") && !(parameters.get("query_status") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_status must be of type String parameters[\"query_status\"]");
        }
        if (parameters.containsKey("query_success") && !(parameters.get("query_success") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: query_success must be of type Boolean parameters[\"query_success\"]");
        }
        if (parameters.containsKey("query_path") && !(parameters.get("query_path") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_path must be of type String parameters[\"query_path\"]");
        }
        if (parameters.containsKey("query_folder") && !(parameters.get("query_folder") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: query_folder must be of type String parameters[\"query_folder\"]");
        }
        String url = String.format("%s%s/action_notification_exports", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<ActionNotificationExport> typeReference = new TypeReference<ActionNotificationExport>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }
}

