/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InboxRecipient
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="company")
    public String company;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="note")
    public String note;
    @JsonProperty(value="recipient")
    public String recipient;
    @JsonProperty(value="sent_at")
    public Date sentAt;
    @JsonProperty(value="inbox_id")
    public Long inboxId;
    @JsonProperty(value="share_after_create")
    public Boolean shareAfterCreate;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public InboxRecipient() {
        this(null, null);
    }

    public InboxRecipient(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public InboxRecipient(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public Date getSentAt() {
        return this.sentAt;
    }

    public void setSentAt(Date sentAt) {
        this.sentAt = sentAt;
    }

    public Long getInboxId() {
        return this.inboxId;
    }

    public void setInboxId(Long inboxId) {
        this.inboxId = inboxId;
    }

    public Boolean getShareAfterCreate() {
        return this.shareAfterCreate;
    }

    public void setShareAfterCreate(Boolean shareAfterCreate) {
        this.shareAfterCreate = shareAfterCreate;
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        InboxRecipient.create(parameters, this.options);
    }

    public static ListIterator<InboxRecipient> list() throws RuntimeException {
        return InboxRecipient.list(null, null);
    }

    public static ListIterator<InboxRecipient> list(HashMap<String, Object> parameters) throws RuntimeException {
        return InboxRecipient.list(parameters, null);
    }

    public static ListIterator<InboxRecipient> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("inbox_id") || parameters.get("inbox_id") == null) {
            throw new NullPointerException("Parameter missing: inbox_id parameters[\"inbox_id\"]");
        }
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("inbox_id") && !(parameters.get("inbox_id") instanceof Long) && !(parameters.get("inbox_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: inbox_id must be of type Long or Integer parameters[\"inbox_id\"]");
        }
        String url = String.format("%s%s/inbox_recipients", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<InboxRecipient>> typeReference = new TypeReference<List<InboxRecipient>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<InboxRecipient> all() throws RuntimeException {
        return InboxRecipient.all(null, null);
    }

    public static ListIterator<InboxRecipient> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return InboxRecipient.list(parameters, options);
    }

    public static InboxRecipient create() throws RuntimeException {
        return InboxRecipient.create(null, null);
    }

    public static InboxRecipient create(HashMap<String, Object> parameters) throws RuntimeException {
        return InboxRecipient.create(parameters, null);
    }

    public static InboxRecipient create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (!parameters.containsKey("inbox_id") || parameters.get("inbox_id") == null) {
            throw new NullPointerException("Parameter missing: inbox_id parameters[\"inbox_id\"]");
        }
        if (!parameters.containsKey("recipient") || parameters.get("recipient") == null) {
            throw new NullPointerException("Parameter missing: recipient parameters[\"recipient\"]");
        }
        if (parameters.containsKey("inbox_id") && !(parameters.get("inbox_id") instanceof Long) && !(parameters.get("inbox_id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: inbox_id must be of type Long or Integer parameters[\"inbox_id\"]");
        }
        if (parameters.containsKey("recipient") && !(parameters.get("recipient") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: recipient must be of type String parameters[\"recipient\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("company") && !(parameters.get("company") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: company must be of type String parameters[\"company\"]");
        }
        if (parameters.containsKey("note") && !(parameters.get("note") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: note must be of type String parameters[\"note\"]");
        }
        if (parameters.containsKey("share_after_create") && !(parameters.get("share_after_create") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: share_after_create must be of type Boolean parameters[\"share_after_create\"]");
        }
        String url = String.format("%s%s/inbox_recipients", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<InboxRecipient> typeReference = new TypeReference<InboxRecipient>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }
}

