/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import com.files.util.ModelUtils;
import com.files.util.UrlUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UserLifecycleRule
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="authentication_method")
    public String authenticationMethod;
    @JsonProperty(value="group_ids")
    public Long[] groupIds;
    @JsonProperty(value="action")
    public String action;
    @JsonProperty(value="inactivity_days")
    public Long inactivityDays;
    @JsonProperty(value="include_folder_admins")
    public Boolean includeFolderAdmins;
    @JsonProperty(value="include_site_admins")
    public Boolean includeSiteAdmins;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="partner_tag")
    public String partnerTag;
    @JsonProperty(value="site_id")
    public Long siteId;
    @JsonProperty(value="user_state")
    public String userState;
    @JsonProperty(value="user_tag")
    public String userTag;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public UserLifecycleRule() {
        this(null, null);
    }

    public UserLifecycleRule(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public UserLifecycleRule(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public Long[] getGroupIds() {
        return this.groupIds;
    }

    public void setGroupIds(Long[] groupIds) {
        this.groupIds = groupIds;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Long getInactivityDays() {
        return this.inactivityDays;
    }

    public void setInactivityDays(Long inactivityDays) {
        this.inactivityDays = inactivityDays;
    }

    public Boolean getIncludeFolderAdmins() {
        return this.includeFolderAdmins;
    }

    public void setIncludeFolderAdmins(Boolean includeFolderAdmins) {
        this.includeFolderAdmins = includeFolderAdmins;
    }

    public Boolean getIncludeSiteAdmins() {
        return this.includeSiteAdmins;
    }

    public void setIncludeSiteAdmins(Boolean includeSiteAdmins) {
        this.includeSiteAdmins = includeSiteAdmins;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPartnerTag() {
        return this.partnerTag;
    }

    public void setPartnerTag(String partnerTag) {
        this.partnerTag = partnerTag;
    }

    public Long getSiteId() {
        return this.siteId;
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
    }

    public String getUserState() {
        return this.userState;
    }

    public void setUserState(String userState) {
        this.userState = userState;
    }

    public String getUserTag() {
        return this.userTag;
    }

    public void setUserTag(String userTag) {
        this.userTag = userTag;
    }

    public UserLifecycleRule update(HashMap<String, Object> parameters) throws IOException {
        return UserLifecycleRule.update(this.id, parameters, this.options);
    }

    public void delete(HashMap<String, Object> parameters) throws IOException {
        UserLifecycleRule.delete(this.id, parameters, this.options);
    }

    public void destroy(HashMap<String, Object> parameters) throws IOException {
        this.delete(parameters);
    }

    public void save() throws IOException {
        HashMap<String, Object> parameters = ModelUtils.toParameterMap(this.objectMapper.writeValueAsString((Object)this));
        UserLifecycleRule.create(parameters, this.options);
    }

    public static ListIterator<UserLifecycleRule> list() throws RuntimeException {
        return UserLifecycleRule.list(null, null);
    }

    public static ListIterator<UserLifecycleRule> list(HashMap<String, Object> parameters) throws RuntimeException {
        return UserLifecycleRule.list(parameters, null);
    }

    public static ListIterator<UserLifecycleRule> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        String url = String.format("%s%s/user_lifecycle_rules", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<UserLifecycleRule>> typeReference = new TypeReference<List<UserLifecycleRule>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<UserLifecycleRule> all() throws RuntimeException {
        return UserLifecycleRule.all(null, null);
    }

    public static ListIterator<UserLifecycleRule> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return UserLifecycleRule.list(parameters, options);
    }

    public static UserLifecycleRule find() throws RuntimeException {
        return UserLifecycleRule.find(null, null, null);
    }

    public static UserLifecycleRule find(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return UserLifecycleRule.find(id, parameters, null);
    }

    public static UserLifecycleRule find(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return UserLifecycleRule.find(null, parameters, options);
    }

    public static UserLifecycleRule find(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        String url = String.format("%s%s/user_lifecycle_rules/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        TypeReference<UserLifecycleRule> typeReference = new TypeReference<UserLifecycleRule>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static UserLifecycleRule get() throws RuntimeException {
        return UserLifecycleRule.get(null, null, null);
    }

    public static UserLifecycleRule get(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return UserLifecycleRule.find(id, parameters, options);
    }

    public static UserLifecycleRule create() throws RuntimeException {
        return UserLifecycleRule.create(null, null);
    }

    public static UserLifecycleRule create(HashMap<String, Object> parameters) throws RuntimeException {
        return UserLifecycleRule.create(parameters, null);
    }

    public static UserLifecycleRule create(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("action") && !(parameters.get("action") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: action must be of type String parameters[\"action\"]");
        }
        if (parameters.containsKey("authentication_method") && !(parameters.get("authentication_method") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: authentication_method must be of type String parameters[\"authentication_method\"]");
        }
        if (parameters.containsKey("group_ids") && !(parameters.get("group_ids") instanceof Long[])) {
            throw new IllegalArgumentException("Bad parameter: group_ids must be of type Long[] parameters[\"group_ids\"]");
        }
        if (parameters.containsKey("inactivity_days") && !(parameters.get("inactivity_days") instanceof Long) && !(parameters.get("inactivity_days") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: inactivity_days must be of type Long or Integer parameters[\"inactivity_days\"]");
        }
        if (parameters.containsKey("include_site_admins") && !(parameters.get("include_site_admins") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: include_site_admins must be of type Boolean parameters[\"include_site_admins\"]");
        }
        if (parameters.containsKey("include_folder_admins") && !(parameters.get("include_folder_admins") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: include_folder_admins must be of type Boolean parameters[\"include_folder_admins\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("partner_tag") && !(parameters.get("partner_tag") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: partner_tag must be of type String parameters[\"partner_tag\"]");
        }
        if (parameters.containsKey("user_state") && !(parameters.get("user_state") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: user_state must be of type String parameters[\"user_state\"]");
        }
        if (parameters.containsKey("user_tag") && !(parameters.get("user_tag") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: user_tag must be of type String parameters[\"user_tag\"]");
        }
        String url = String.format("%s%s/user_lifecycle_rules", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<UserLifecycleRule> typeReference = new TypeReference<UserLifecycleRule>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.POST, typeReference, parameters, options);
    }

    public static UserLifecycleRule update() throws RuntimeException {
        return UserLifecycleRule.update(null, null, null);
    }

    public static UserLifecycleRule update(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        return UserLifecycleRule.update(id, parameters, null);
    }

    public static UserLifecycleRule update(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return UserLifecycleRule.update(null, parameters, options);
    }

    public static UserLifecycleRule update(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        if (parameters.containsKey("action") && !(parameters.get("action") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: action must be of type String parameters[\"action\"]");
        }
        if (parameters.containsKey("authentication_method") && !(parameters.get("authentication_method") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: authentication_method must be of type String parameters[\"authentication_method\"]");
        }
        if (parameters.containsKey("group_ids") && !(parameters.get("group_ids") instanceof Long[])) {
            throw new IllegalArgumentException("Bad parameter: group_ids must be of type Long[] parameters[\"group_ids\"]");
        }
        if (parameters.containsKey("inactivity_days") && !(parameters.get("inactivity_days") instanceof Long) && !(parameters.get("inactivity_days") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: inactivity_days must be of type Long or Integer parameters[\"inactivity_days\"]");
        }
        if (parameters.containsKey("include_site_admins") && !(parameters.get("include_site_admins") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: include_site_admins must be of type Boolean parameters[\"include_site_admins\"]");
        }
        if (parameters.containsKey("include_folder_admins") && !(parameters.get("include_folder_admins") instanceof Boolean)) {
            throw new IllegalArgumentException("Bad parameter: include_folder_admins must be of type Boolean parameters[\"include_folder_admins\"]");
        }
        if (parameters.containsKey("name") && !(parameters.get("name") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: name must be of type String parameters[\"name\"]");
        }
        if (parameters.containsKey("partner_tag") && !(parameters.get("partner_tag") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: partner_tag must be of type String parameters[\"partner_tag\"]");
        }
        if (parameters.containsKey("user_state") && !(parameters.get("user_state") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: user_state must be of type String parameters[\"user_state\"]");
        }
        if (parameters.containsKey("user_tag") && !(parameters.get("user_tag") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: user_tag must be of type String parameters[\"user_tag\"]");
        }
        String url = String.format("%s%s/user_lifecycle_rules/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        TypeReference<UserLifecycleRule> typeReference = new TypeReference<UserLifecycleRule>(){};
        return FilesClient.requestItem(url, HttpMethods.RequestMethods.PATCH, typeReference, parameters, options);
    }

    public static void delete() throws RuntimeException {
        UserLifecycleRule.delete(null, null, null);
    }

    public static void delete(Long id, HashMap<String, Object> parameters) throws RuntimeException {
        UserLifecycleRule.delete(id, parameters, null);
    }

    public static void delete(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        UserLifecycleRule.delete(null, parameters, options);
    }

    public static void delete(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (id == null && parameters.containsKey("id") && parameters.get("id") != null) {
            id = (Long)parameters.get("id");
        }
        if (id == null) {
            throw new NullPointerException("Argument or Parameter missing: id parameters[\"id\"]");
        }
        if (!(id instanceof Long) && !(parameters.get("id") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: id must be of type Long or Integer parameters[\"id\"]");
        }
        String url = String.format("%s%s/user_lifecycle_rules/%s", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase(), UrlUtils.encodeUrlPath(String.valueOf(id)));
        FilesClient.apiRequest(url, HttpMethods.RequestMethods.DELETE, parameters, options);
    }

    public static void destroy() throws RuntimeException {
        UserLifecycleRule.destroy(null, null, null);
    }

    public static void destroy(Long id, HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        UserLifecycleRule.delete(id, parameters, options);
    }
}

