/*
 * Decompiled with CFR 0.152.
 */
package com.files.models;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.files.FilesClient;
import com.files.FilesConfig;
import com.files.ListIterator;
import com.files.models.ModelInterface;
import com.files.net.HttpMethods;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EmailIncomingMessage
implements ModelInterface {
    private HashMap<String, Object> options;
    private ObjectMapper objectMapper = ((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().disable(new MapperFeature[]{MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS})).disable(new SerializationFeature[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS})).defaultDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX"))).build();
    @JsonProperty(value="id")
    public Long id;
    @JsonProperty(value="inbox_id")
    public Long inboxId;
    @JsonProperty(value="sender")
    public String sender;
    @JsonProperty(value="sender_name")
    public String senderName;
    @JsonProperty(value="status")
    public String status;
    @JsonProperty(value="body")
    public String body;
    @JsonProperty(value="message")
    public String message;
    @JsonProperty(value="created_at")
    public Date createdAt;
    @JsonProperty(value="inbox_title")
    public String inboxTitle;

    @Override
    public void setOptions(HashMap<String, Object> options) {
        this.options = options;
    }

    public EmailIncomingMessage() {
        this(null, null);
    }

    public EmailIncomingMessage(HashMap<String, Object> parameters) {
        this(parameters, null);
    }

    public EmailIncomingMessage(HashMap<String, Object> parameters, HashMap<String, Object> options) {
        this.options = options;
        try {
            ObjectReader objectReader = this.objectMapper.readerForUpdating((Object)this);
            objectReader.readValue(this.objectMapper.writeValueAsString(parameters));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
    }

    public Long getId() {
        return this.id;
    }

    public Long getInboxId() {
        return this.inboxId;
    }

    public String getSender() {
        return this.sender;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public String getStatus() {
        return this.status;
    }

    public String getBody() {
        return this.body;
    }

    public String getMessage() {
        return this.message;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public String getInboxTitle() {
        return this.inboxTitle;
    }

    public static ListIterator<EmailIncomingMessage> list() throws RuntimeException {
        return EmailIncomingMessage.list(null, null);
    }

    public static ListIterator<EmailIncomingMessage> list(HashMap<String, Object> parameters) throws RuntimeException {
        return EmailIncomingMessage.list(parameters, null);
    }

    public static ListIterator<EmailIncomingMessage> list(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        parameters = parameters != null ? parameters : new HashMap<String, Object>();
        HashMap<String, Object> hashMap = options = options != null ? options : new HashMap<String, Object>();
        if (parameters.containsKey("cursor") && !(parameters.get("cursor") instanceof String)) {
            throw new IllegalArgumentException("Bad parameter: cursor must be of type String parameters[\"cursor\"]");
        }
        if (parameters.containsKey("per_page") && !(parameters.get("per_page") instanceof Long) && !(parameters.get("per_page") instanceof Integer)) {
            throw new IllegalArgumentException("Bad parameter: per_page must be of type Long or Integer parameters[\"per_page\"]");
        }
        if (parameters.containsKey("sort_by") && !(parameters.get("sort_by") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: sort_by must be of type Map<String, String> parameters[\"sort_by\"]");
        }
        if (parameters.containsKey("filter") && !(parameters.get("filter") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter must be of type Map<String, String> parameters[\"filter\"]");
        }
        if (parameters.containsKey("filter_gt") && !(parameters.get("filter_gt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gt must be of type Map<String, String> parameters[\"filter_gt\"]");
        }
        if (parameters.containsKey("filter_gteq") && !(parameters.get("filter_gteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_gteq must be of type Map<String, String> parameters[\"filter_gteq\"]");
        }
        if (parameters.containsKey("filter_prefix") && !(parameters.get("filter_prefix") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_prefix must be of type Map<String, String> parameters[\"filter_prefix\"]");
        }
        if (parameters.containsKey("filter_lt") && !(parameters.get("filter_lt") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lt must be of type Map<String, String> parameters[\"filter_lt\"]");
        }
        if (parameters.containsKey("filter_lteq") && !(parameters.get("filter_lteq") instanceof Map)) {
            throw new IllegalArgumentException("Bad parameter: filter_lteq must be of type Map<String, String> parameters[\"filter_lteq\"]");
        }
        String url = String.format("%s%s/email_incoming_messages", FilesConfig.getInstance().getApiRoot(), FilesConfig.getInstance().getApiBase());
        TypeReference<List<EmailIncomingMessage>> typeReference = new TypeReference<List<EmailIncomingMessage>>(){};
        return FilesClient.requestList(url, HttpMethods.RequestMethods.GET, typeReference, parameters, options);
    }

    public static ListIterator<EmailIncomingMessage> all() throws RuntimeException {
        return EmailIncomingMessage.all(null, null);
    }

    public static ListIterator<EmailIncomingMessage> all(HashMap<String, Object> parameters, HashMap<String, Object> options) throws RuntimeException {
        return EmailIncomingMessage.list(parameters, options);
    }
}

