/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.krasa.validations;

import com.sun.codemodel.JFieldVar;
import com.sun.tools.xjc.addon.krasa.validations.ValidationsAnnotation;
import com.sun.tools.xjc.addon.krasa.validations.ValidationsLogger;
import com.sun.tools.xjc.addon.krasa.validations.XjcAnnotator;
import com.sun.tools.xjc.outline.ClassOutline;
import cz.jirutka.validator.collection.constraints.EachDecimalMax;
import cz.jirutka.validator.collection.constraints.EachDecimalMin;
import cz.jirutka.validator.collection.constraints.EachDigits;
import cz.jirutka.validator.collection.constraints.EachPattern;
import cz.jirutka.validator.collection.constraints.EachSize;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

class FieldAnnotator {
    private static final String FRACTION = "fraction";
    private static final String INTEGER = "integer";
    private static final String MAX = "max";
    private static final String MIN = "min";
    private static final String INCLUSIVE = "inclusive";
    private static final String VALUE = "value";
    private static final String MESSAGE = "message";
    private static final String REGEXP = "regexp";
    private final ValidationsAnnotation annotationFactory;
    private final XjcAnnotator xjcAnnotator;

    public FieldAnnotator(JFieldVar field, ValidationsAnnotation annotationFactory, ValidationsLogger log) {
        this.annotationFactory = annotationFactory;
        this.xjcAnnotator = new XjcAnnotator(field, log);
    }

    void addEachSizeAnnotation(Integer minLength, Integer maxLength) {
        if (minLength != null && minLength != 0 || maxLength != null && maxLength != 0) {
            this.xjcAnnotator.annotate(EachSize.class).param(MIN, minLength).param(MAX, maxLength).log();
        }
    }

    void addEachDigitsAnnotation(Integer totalDigits, Integer fractionDigits) {
        if (totalDigits != null && totalDigits != 0 || fractionDigits != null && fractionDigits != 0) {
            this.xjcAnnotator.annotate(EachDigits.class).param(INTEGER, totalDigits, 0).param(FRACTION, fractionDigits, 0).log();
        }
    }

    void addEachDecimalMaxAnnotation(BigDecimal maxInclusive, BigDecimal maxExclusive) {
        if (maxInclusive != null || maxExclusive != null) {
            this.xjcAnnotator.annotate(EachDecimalMax.class).param(VALUE, maxInclusive).param(VALUE, maxExclusive).param(INCLUSIVE, maxInclusive != null).log();
        }
    }

    void addEachDecimalMinAnnotation(BigDecimal minInclusive, BigDecimal minExclusive) {
        if (minExclusive != null || minInclusive != null) {
            this.xjcAnnotator.annotate(EachDecimalMin.class).param(VALUE, minInclusive).param(VALUE, minExclusive).param(INCLUSIVE, minInclusive != null).log();
        }
    }

    void addNotNullAnnotation(ClassOutline classOutline, JFieldVar field, String message) {
        this.xjcAnnotator.annotate(this.annotationFactory.getNotNullClass()).param(MESSAGE, message).log();
    }

    void addValidAnnotation() {
        this.xjcAnnotator.annotate(this.annotationFactory.getValidClass()).log();
    }

    void addSizeAnnotation(Integer minLength, Integer maxLength, Integer length) {
        if (FieldAnnotator.isValidLength(minLength) || FieldAnnotator.isValidLength(maxLength)) {
            this.xjcAnnotator.annotate(this.annotationFactory.getSizeClass()).paramIf(FieldAnnotator.isValidLength(minLength), MIN, minLength).paramIf(FieldAnnotator.isValidLength(maxLength), MAX, maxLength).log();
        } else if (FieldAnnotator.isValidLength(length)) {
            this.xjcAnnotator.annotate(this.annotationFactory.getSizeClass()).param(MIN, length).param(MAX, length).log();
        }
    }

    void addDecimalMinAnnotationExclusive(BigDecimal min) {
        this.addDecimalMinAnnotation(min, true);
    }

    void addDecimalMinAnnotationInclusive(BigDecimal min) {
        this.addDecimalMinAnnotation(min, false);
    }

    private void addDecimalMinAnnotation(BigDecimal min, boolean exclusive) {
        if (min != null) {
            this.xjcAnnotator.annotate(this.annotationFactory.getDecimalMinClass()).param(VALUE, min.toString()).param(INCLUSIVE, !exclusive).log();
        }
    }

    void addDecimalMaxAnnotationExclusive(BigDecimal max) {
        this.addDecimalMaxAnnotation(max, true);
    }

    void addDecimalMaxAnnotationInclusive(BigDecimal max) {
        this.addDecimalMaxAnnotation(max, false);
    }

    private void addDecimalMaxAnnotation(BigDecimal max, boolean exclusive) {
        if (max != null) {
            this.xjcAnnotator.annotate(this.annotationFactory.getDecimalMaxClass()).param(VALUE, max.toString()).param(INCLUSIVE, !exclusive).log();
        }
    }

    void addDigitsAnnotation(Integer totalDigits, Integer fractionDigits) {
        if (totalDigits != null) {
            this.xjcAnnotator.annotate(this.annotationFactory.getDigitsClass()).param(INTEGER, FieldAnnotator.getValueOrZeroOnNull(totalDigits)).param(FRACTION, FieldAnnotator.getValueOrZeroOnNull(fractionDigits)).log();
        }
    }

    void addPatterns(LinkedHashSet<LinkedHashSet<String>> patterns, boolean multiPattern) {
        this.addMultiPatternAnnotations(this.annotationFactory.getPatternClass(), patterns, multiPattern);
    }

    void addEachPatterns(LinkedHashSet<LinkedHashSet<String>> patterns, boolean multiPattern) {
        this.addMultiPatternAnnotations(EachPattern.class, patterns, multiPattern);
    }

    private void addMultiPatternAnnotations(Class<? extends Annotation> annotation, LinkedHashSet<LinkedHashSet<String>> multiPatterns, boolean multiPattern) {
        switch (multiPatterns.size()) {
            case 0: {
                break;
            }
            case 1: {
                this.addPatternAnnotations(annotation, (Collection)multiPatterns.iterator().next());
                break;
            }
            default: {
                if (multiPattern) {
                    multiPatterns.forEach(p -> this.addPatternAnnotations(annotation, (Collection<String>)p));
                    break;
                }
                this.addPatternListAnnotation(multiPatterns);
            }
        }
    }

    void addPatternListAnnotation(LinkedHashSet<LinkedHashSet<String>> multiPatterns) {
        XjcAnnotator.Annotate.MultipleAnnotation multi = this.xjcAnnotator.annotate(this.annotationFactory.getPatternListClass()).multipleAnnotationContainer(VALUE);
        block4: for (Set set : multiPatterns) {
            switch (set.size()) {
                case 0: {
                    continue block4;
                }
                case 1: {
                    multi.annotate(this.annotationFactory.getPatternClass()).param(REGEXP, (String)set.iterator().next()).log();
                    continue block4;
                }
            }
            String pattern = this.consolidatePatterns(set);
            multi.annotate(this.annotationFactory.getPatternClass()).param(REGEXP, pattern).log();
        }
    }

    private void addPatternAnnotations(Class<? extends Annotation> annotation, Collection<String> patterns) {
        switch (patterns.size()) {
            case 0: {
                break;
            }
            case 1: {
                this.addSinglePatternAnnotation(annotation, patterns.iterator().next());
                break;
            }
            default: {
                this.addPatternAnnotation(annotation, patterns);
            }
        }
    }

    private void addPatternAnnotation(Class<? extends Annotation> annotation, Collection<String> patterns) {
        String regexp = this.consolidatePatterns(patterns);
        this.addSinglePatternAnnotation(annotation, regexp);
    }

    private String consolidatePatterns(Collection<String> patterns) {
        StringBuilder sb = new StringBuilder();
        for (String p : patterns) {
            sb.append("(").append(p).append(")|");
        }
        String regexp = sb.substring(0, sb.length() - 1);
        return regexp;
    }

    private void addSinglePatternAnnotation(Class<? extends Annotation> annotation, String pattern) {
        this.xjcAnnotator.annotate(annotation).param(REGEXP, pattern).log();
    }

    static boolean isValidLength(Integer length) {
        return length != null && length != -1;
    }

    static Integer getValueOrZeroOnNull(Integer value) {
        return value == null ? Integer.valueOf(0) : value;
    }
}

