/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.krasa.validations;

import com.sun.codemodel.JFieldVar;
import com.sun.tools.xjc.addon.krasa.validations.NumericRange;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

class FieldHelper {
    private final JFieldVar field;
    private static final Set<String> NUMBERS = Arrays.stream(new Class[]{BigDecimal.class, BigInteger.class, Byte.class, Short.class, Integer.class, Double.class, Float.class, Long.class}).map(c -> c.getSimpleName().toUpperCase()).collect(Collectors.toSet());

    public FieldHelper(JFieldVar field) {
        this.field = field;
    }

    public BigDecimal validValue(BigDecimal value) {
        if (value != null) {
            String typeName = this.field.type().boxify().fullName();
            return NumericRange.valid(typeName, value);
        }
        return null;
    }

    public boolean isString() {
        return this.field.type().name().equals("String");
    }

    public boolean isStringList() {
        return this.field.type().name().equals("List<String>");
    }

    public boolean isList() {
        return this.field.type().name().startsWith("List<");
    }

    public boolean isArray() {
        return this.field.type().isArray();
    }

    public boolean isCustomType() {
        return "JDirectClass".equals(this.field.type().getClass().getSimpleName());
    }

    public boolean isNumber() {
        return FieldHelper.isFieldTypeNameNumber(this.field.type().boxify().name()) || FieldHelper.isFieldTypeFullNameNumber(this.field.type().fullName());
    }

    static boolean isFieldTypeNameNumber(String fieldTypeName) {
        return NUMBERS.contains(fieldTypeName.toUpperCase());
    }

    static boolean isFieldTypeFullNameNumber(String fieldTypeFullName) {
        try {
            if (FieldHelper.isNumber(Class.forName(fieldTypeFullName))) {
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    static boolean isNumber(Class<?> aClass) {
        return Number.class.isAssignableFrom(aClass);
    }
}

