/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.krasa.validations;

import com.sun.codemodel.JFieldVar;
import com.sun.tools.xjc.addon.krasa.validations.AccumulatorFacet;
import com.sun.tools.xjc.addon.krasa.validations.FieldAnnotator;
import com.sun.tools.xjc.addon.krasa.validations.FieldHelper;
import com.sun.tools.xjc.addon.krasa.validations.HierarchyFacetGatherer;
import com.sun.tools.xjc.addon.krasa.validations.SilentValidationLogger;
import com.sun.tools.xjc.addon.krasa.validations.SystemOutValidationsLogger;
import com.sun.tools.xjc.addon.krasa.validations.Utils;
import com.sun.tools.xjc.addon.krasa.validations.ValidationsLogger;
import com.sun.tools.xjc.addon.krasa.validations.ValidationsOptions;
import com.sun.tools.xjc.model.CAttributePropertyInfo;
import com.sun.tools.xjc.model.CElementPropertyInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.model.CValuePropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.impl.AttributeUseImpl;
import com.sun.xml.xsom.impl.ElementDecl;
import com.sun.xml.xsom.impl.ModelGroupImpl;
import com.sun.xml.xsom.impl.SimpleTypeImpl;
import java.lang.annotation.Annotation;
import java.util.List;

public class Processor {
    private final ValidationsOptions options;

    public Processor(ValidationsOptions options) {
        this.options = options;
    }

    public void process(Outline model) {
        for (ClassOutline classOutline : model.getClasses()) {
            String className = classOutline.implClass.name();
            List properties = classOutline.target.getProperties();
            for (CPropertyInfo property : properties) {
                String propertyName = property.getName(false);
                ValidationsLogger logger = this.options.isVerbose() ? new SystemOutValidationsLogger(className, propertyName) : SilentValidationLogger.INSTANCE;
                new TypeProcessor(classOutline, logger).processProperty(property);
            }
        }
    }

    String notNullMessage(ClassOutline classOutline, JFieldVar field) {
        String className = classOutline.implClass.name();
        Class<? extends Annotation> notNullClass = this.options.getAnnotationFactory().getNotNullClass();
        String message = null;
        if (this.options.isNotNullPrefixClassName()) {
            message = String.format("%s.%s {%s.message}", className, field.name(), notNullClass.getName());
        } else if (this.options.isNotNullPrefixFieldName()) {
            message = String.format("%s {%s.message}", field.name(), notNullClass.getName());
        } else if (this.options.isNotNullCustomMessage()) {
            message = String.format("{%s.message}", notNullClass.getName());
        } else if (this.options.getNotNullCustomMessageText() != null) {
            message = this.options.getNotNullCustomMessageText().replace("{ClassName}", className).replace("{FieldName}", field.name());
        }
        return message;
    }

    class TypeProcessor {
        private final ValidationsLogger logger;
        private final ClassOutline classOutline;

        public TypeProcessor(ClassOutline classOutline, ValidationsLogger logger) {
            this.logger = logger;
            this.classOutline = classOutline;
        }

        public void processProperty(CPropertyInfo property) {
            if (property instanceof CElementPropertyInfo) {
                this.processElement((CElementPropertyInfo)property);
            } else if (property instanceof CAttributePropertyInfo) {
                this.processAttribute((CAttributePropertyInfo)property);
            } else if (property instanceof CValuePropertyInfo) {
                this.processAttribute((CValuePropertyInfo)property);
            }
        }

        private void processElement(CElementPropertyInfo property) {
            String propertyName = property.getName(false);
            XSParticle particle = (XSParticle)property.getSchemaComponent();
            XSTerm term = particle.getTerm();
            JFieldVar field = (JFieldVar)this.classOutline.implClass.fields().get(propertyName);
            FieldAnnotator annotator = new FieldAnnotator(field, Processor.this.options.getAnnotationFactory(), this.logger);
            if (term instanceof ModelGroupImpl) {
                this.processModelGroupIml(annotator);
            } else if (term instanceof ElementDecl) {
                this.processElementDecl(property, field, particle, (ElementDecl)term, annotator);
            }
        }

        private void processModelGroupIml(FieldAnnotator annotator) {
            annotator.addValidAnnotation();
        }

        private void processElementDecl(CElementPropertyInfo property, JFieldVar field, XSParticle particle, ElementDecl element, FieldAnnotator annotator) {
            XSSimpleType simpleType;
            String name = property.getName(true);
            int minOccurs = particle.getMinOccurs().intValue();
            int maxOccurs = particle.getMaxOccurs().intValue();
            boolean required = property.isRequired() || property.isCollectionRequired();
            boolean nillable = element.isNillable() || property.isCollectionNillable();
            String targetNamespace = element.getOwnerSchema().getTargetNamespace();
            XSType elementType = element.getType();
            boolean isComplexType = elementType.isComplexType();
            FieldHelper fieldHelper = new FieldHelper(field);
            if (Processor.this.options.isNotNullAnnotations() && !nillable && required) {
                String message = Processor.this.notNullMessage(this.classOutline, field);
                annotator.addNotNullAnnotation(this.classOutline, field, message);
            }
            if (property.isCollection() && (minOccurs != 1 || maxOccurs != 1)) {
                annotator.addSizeAnnotation(minOccurs, maxOccurs, null);
            }
            if ((property.isCollection() || isComplexType) && Utils.isEqualsOrNull(Processor.this.options.getTargetNamespace(), targetNamespace)) {
                annotator.addValidAnnotation();
            }
            if ((simpleType = isComplexType ? elementType.getBaseType().asSimpleType() : elementType.asSimpleType()) != null) {
                AccumulatorFacet facet = HierarchyFacetGatherer.gatherRestrictions(simpleType);
                if (property.isCollection()) {
                    if (fieldHelper.isList()) {
                        annotator.addSizeAnnotation(facet.minLength(), facet.maxLength(), facet.length());
                    }
                    if (Processor.this.options.isValidationCollection()) {
                        AccumulatorFacet itemFacet = facet.getItemFacet();
                        if (itemFacet != null) {
                            this.setEachAnnotations(annotator, itemFacet);
                        } else {
                            if (!fieldHelper.isList()) {
                                throw new AssertionError((Object)"That's unexpected: please report this exception along with the XSD that provoked it.");
                            }
                            this.setEachAnnotations(annotator, facet);
                        }
                    }
                } else {
                    this.processType(fieldHelper, annotator, facet);
                }
            }
        }

        private void setEachAnnotations(FieldAnnotator annotator, AccumulatorFacet facet) {
            annotator.addEachSizeAnnotation(facet.minLength(), facet.maxLength());
            annotator.addEachDigitsAnnotation(facet.totalDigits(), facet.fractionDigits());
            annotator.addEachDecimalMinAnnotation(facet.minInclusive(), facet.minExclusive());
            annotator.addEachDecimalMaxAnnotation(facet.maxInclusive(), facet.maxExclusive());
            annotator.addEachPatterns(facet.getMultiPatterns(), Processor.this.options.isMultiPattern());
        }

        private void processAttribute(CAttributePropertyInfo property) {
            String propertyName = property.getName(false);
            XSComponent definition = property.getSchemaComponent();
            if (definition instanceof AttributeUseImpl) {
                AttributeUseImpl particle = (AttributeUseImpl)definition;
                XSSimpleType type = particle.getDecl().getType();
                JFieldVar field = (JFieldVar)this.classOutline.implClass.fields().get(propertyName);
                if (field != null) {
                    FieldAnnotator annotator = new FieldAnnotator(field, Processor.this.options.getAnnotationFactory(), this.logger);
                    if (particle.isRequired()) {
                        String message = Processor.this.notNullMessage(this.classOutline, field);
                        annotator.addNotNullAnnotation(this.classOutline, field, message);
                    }
                    this.processType(type, field, annotator);
                }
            }
        }

        private void processAttribute(CValuePropertyInfo property) {
            String propertyName = property.getName(false);
            XSComponent definition = property.getSchemaComponent();
            if (definition instanceof SimpleTypeImpl) {
                SimpleTypeImpl particle = (SimpleTypeImpl)definition;
                XSSimpleType simpleType = particle.asSimpleType();
                JFieldVar field = (JFieldVar)this.classOutline.implClass.fields().get(propertyName);
                if (field != null) {
                    FieldAnnotator annotator = new FieldAnnotator(field, Processor.this.options.getAnnotationFactory(), this.logger);
                    this.processType(simpleType, field, annotator);
                }
            }
        }

        private void processType(XSSimpleType simpleType, JFieldVar field, FieldAnnotator annotator) {
            AccumulatorFacet facet = HierarchyFacetGatherer.gatherRestrictions(simpleType);
            FieldHelper fieldHelper = new FieldHelper(field);
            this.processType(fieldHelper, annotator, facet);
        }

        private void processType(FieldHelper fieldHelper, FieldAnnotator annotator, AccumulatorFacet facet) {
            if (fieldHelper.isArray() || fieldHelper.isString() || fieldHelper.isStringList()) {
                annotator.addSizeAnnotation(facet.minLength(), facet.maxLength(), facet.length());
            }
            if (fieldHelper.isString()) {
                annotator.addPatterns(facet.getMultiPatterns(), Processor.this.options.isMultiPattern());
            }
            if (fieldHelper.isNumber() || fieldHelper.isString()) {
                if (Processor.this.options.isAllNumericConstraints()) {
                    annotator.addDecimalMinAnnotationInclusive(facet.minInclusive());
                    annotator.addDecimalMinAnnotationExclusive(facet.minExclusive());
                    annotator.addDecimalMaxAnnotationInclusive(facet.maxInclusive());
                    annotator.addDecimalMaxAnnotationExclusive(facet.maxExclusive());
                } else {
                    annotator.addDecimalMinAnnotationInclusive(fieldHelper.validValue(facet.minInclusive()));
                    annotator.addDecimalMinAnnotationExclusive(fieldHelper.validValue(facet.minExclusive()));
                    annotator.addDecimalMaxAnnotationInclusive(fieldHelper.validValue(facet.maxInclusive()));
                    annotator.addDecimalMaxAnnotationExclusive(fieldHelper.validValue(facet.maxExclusive()));
                }
                annotator.addDigitsAnnotation(facet.totalDigits(), facet.fractionDigits());
            }
        }
    }
}

