/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.krasa.validations;

import com.sun.tools.xjc.addon.krasa.validations.ValidationsOptions;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.common.model.JavaParameter;

public class ProcessorForJavaMethod {
    private static final String NAME = ProcessorForJavaMethod.class.getSimpleName();
    private static final String LOG_PREFIX = NAME + ": ";
    private static final String VALID_PARAM = "VALID_PARAM";
    private static final String VALID_RETURN = "VALID_RETURN";
    private final ValidationsOptions validationsOptions;
    private final JAnnotation validAnnotationClass;

    public ProcessorForJavaMethod(ValidationsOptions validationsOptions) {
        this.validationsOptions = validationsOptions;
        this.validAnnotationClass = new JAnnotation(validationsOptions.getAnnotationFactory().getValidClass());
    }

    public void process(JavaMethod javaMethod) {
        if (this.validationsOptions.isValidOut()) {
            this.log("adding annotation to " + javaMethod.getSignature());
            javaMethod.addAnnotation(VALID_RETURN, this.validAnnotationClass);
        }
        javaMethod.getParameters().forEach(this::process);
    }

    private void process(JavaParameter javaParameter) {
        if (this.validationsOptions.isValidIn() && (javaParameter.isIN() || javaParameter.isINOUT())) {
            this.log("adding in " + javaParameter.getName());
            javaParameter.addAnnotation(VALID_PARAM, this.validAnnotationClass);
        }
        if (this.validationsOptions.isValidOut() && (javaParameter.isOUT() || javaParameter.isINOUT())) {
            this.log("adding out " + javaParameter.getName());
            javaParameter.addAnnotation(VALID_RETURN, this.validAnnotationClass);
        }
    }

    void log(String message) {
        if (this.validationsOptions.isVerbose()) {
            System.out.println(LOG_PREFIX + message);
        }
    }
}

