/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.krasa.validations;

import jakarta.validation.Valid;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Pattern;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;

public enum ValidationsAnnotation {
    JAVAX{

        @Override
        public Class<? extends Annotation> getNotNullClass() {
            return NotNull.class;
        }

        @Override
        public Class<? extends Annotation> getValidClass() {
            return javax.validation.Valid.class;
        }

        @Override
        public Class<? extends Annotation> getSizeClass() {
            return Size.class;
        }

        @Override
        public Class<? extends Annotation> getDigitsClass() {
            return javax.validation.constraints.Digits.class;
        }

        @Override
        public Class<? extends Annotation> getDecimalMinClass() {
            return DecimalMin.class;
        }

        @Override
        public Class<? extends Annotation> getDecimalMaxClass() {
            return javax.validation.constraints.DecimalMax.class;
        }

        @Override
        public Class<? extends Annotation> getPatternClass() {
            return javax.validation.constraints.Pattern.class;
        }

        @Override
        public Class<? extends Annotation> getPatternListClass() {
            return Pattern.List.class;
        }
    }
    ,
    JAKARTA{

        @Override
        public Class<? extends Annotation> getNotNullClass() {
            return jakarta.validation.constraints.NotNull.class;
        }

        @Override
        public Class<? extends Annotation> getValidClass() {
            return Valid.class;
        }

        @Override
        public Class<? extends Annotation> getSizeClass() {
            return jakarta.validation.constraints.Size.class;
        }

        @Override
        public Class<? extends Annotation> getDigitsClass() {
            return Digits.class;
        }

        @Override
        public Class<? extends Annotation> getDecimalMinClass() {
            return jakarta.validation.constraints.DecimalMin.class;
        }

        @Override
        public Class<? extends Annotation> getDecimalMaxClass() {
            return DecimalMax.class;
        }

        @Override
        public Class<? extends Annotation> getPatternClass() {
            return Pattern.class;
        }

        @Override
        public Class<? extends Annotation> getPatternListClass() {
            return Pattern.List.class;
        }
    };

    private final List<Class<?>> classList = Arrays.asList(this.getValidClass(), this.getNotNullClass(), this.getSizeClass(), this.getDigitsClass(), this.getDecimalMinClass(), this.getDecimalMaxClass(), this.getPatternClass(), this.getPatternListClass());
    private final Map<String, String> classMap = this.classList.stream().collect(Collectors.toMap(Class::getSimpleName, Class::getCanonicalName));

    public abstract Class<? extends Annotation> getValidClass();

    public abstract Class<? extends Annotation> getNotNullClass();

    public abstract Class<? extends Annotation> getSizeClass();

    public abstract Class<? extends Annotation> getDigitsClass();

    public abstract Class<? extends Annotation> getDecimalMinClass();

    public abstract Class<? extends Annotation> getDecimalMaxClass();

    public abstract Class<? extends Annotation> getPatternClass();

    public abstract Class<? extends Annotation> getPatternListClass();

    public String getCanonicalClassName(String className) throws ClassNotFoundException {
        String canonicalName = this.classMap.get(Objects.requireNonNull(className));
        if (canonicalName == null) {
            throw new ClassNotFoundException(className);
        }
        return canonicalName;
    }

    public static String getValuesAsString() {
        return Arrays.asList(ValidationsAnnotation.values()).stream().map(v -> v.name()).collect(Collectors.joining(","));
    }
}

