/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.krasa.validations;

import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.addon.krasa.validations.NotNullAnnotationCustomMessageType;
import com.sun.tools.xjc.addon.krasa.validations.ValidationsAnnotation;
import com.sun.tools.xjc.addon.krasa.validations.ValidationsOptions;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public enum ValidationsArgument {
    targetNamespace(String.class, "adds @Valid annotation to all elements with given namespace.", (p, v) -> {
        if (v == null || v.contains(" ")) {
            return "invalid namespace";
        }
        p.targetNamespace((String)v);
        return null;
    }, p -> p.getTargetNamespace()),
    multiPattern(Boolean.class, "uses a multiple javax validation @Pattern instead of @Pattern.List", (p, v) -> ValidationsArgument.setBoolean(v, r -> p.multiPattern((boolean)r)), p -> p.isMultiPattern()),
    generateAllNumericConstraints(Boolean.class, "adds @DecinalMin and @DecimalMax annotations even if within the range of the java type", (p, v) -> ValidationsArgument.setBoolean(v, r -> p.allNumericConstraints((boolean)r)), p -> p.isAllNumericConstraints()),
    generateNotNullAnnotations(Boolean.class, "adds a @NotNull when an element has minOccours not 0, is required or is not nillable", (p, v) -> ValidationsArgument.setBoolean(v, r -> p.notNullAnnotations((boolean)r)), p -> p.isNotNullAnnotations()),
    notNullAnnotationsCustomMessages(String.class, "allowed values: true/false, 'FieldName', 'ClassName' or an actual message", (p, v) -> {
        Boolean b = ValidationsArgument.toBoolean(v);
        if (b != null) {
            p.notNullCustomMessage(b);
        } else if (NotNullAnnotationCustomMessageType.Classname.equalsIgnoreCase((String)v)) {
            p.notNullCustomMessage(true);
            p.notNullPrefixFieldName(false);
            p.notNullPrefixClassName(true);
            p.notNullCustomMessageText(null);
        } else if (NotNullAnnotationCustomMessageType.Fieldname.equalsIgnoreCase((String)v)) {
            p.notNullCustomMessage(true);
            p.notNullPrefixFieldName(true);
            p.notNullPrefixClassName(false);
            p.notNullCustomMessageText(null);
        } else if (v.equalsIgnoreCase("false")) {
            p.notNullCustomMessage(false);
            p.notNullPrefixFieldName(false);
            p.notNullPrefixClassName(false);
            p.notNullCustomMessageText(null);
        } else {
            p.notNullCustomMessage(false);
            p.notNullPrefixFieldName(false);
            p.notNullPrefixClassName(false);
            p.notNullCustomMessageText((String)v);
        }
        return null;
    }, p -> {
        if (p.isNotNullPrefixFieldName()) {
            return "FieldName";
        }
        if (p.isNotNullPrefixClassName()) {
            return "ClassName";
        }
        if (p.getNotNullCustomMessageText() != null) {
            return p.getNotNullCustomMessageText();
        }
        return p.isNotNullCustomMessage();
    }),
    verbose(Boolean.class, "increases verbosity", (p, v) -> ValidationsArgument.setBoolean(v, r -> p.verbose((boolean)r)), p -> p.isVerbose()),
    validationAnnotations(String.class, "selects which type of annotation to use: " + ValidationsAnnotation.getValuesAsString(), (p, v) -> {
        ValidationsAnnotation va;
        try {
            va = ValidationsAnnotation.valueOf(v.toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException ex) {
            return "passed value is not allowed, use one of: " + ValidationsAnnotation.getValuesAsString();
        }
        p.annotationFactory(va);
        return null;
    }, p -> p.getAnnotationFactory()),
    generateListAnnotations(Boolean.class, "generates github.com/jirutka/validator-collection annotations", (p, v) -> ValidationsArgument.setBoolean(v, r -> p.validationCollection((boolean)r)), p -> p.isValidationCollection()),
    generateServiceValidationAnnotations(String.class, "used by cxf-codegen to perform validations on fields annotated with @Valid", (p, v) -> {
        if ("in".equalsIgnoreCase((String)v)) {
            p.validIn(true);
            p.validOut(false);
        } else if ("out".equalsIgnoreCase((String)v)) {
            p.validOut(true);
            p.validIn(false);
        } else if ("inout".equalsIgnoreCase((String)v)) {
            p.validOut(true);
            p.validIn(true);
        }
        return null;
    }, p -> {
        if (p.isValidIn() && p.isValidOut()) {
            return "inOut";
        }
        if (p.isValidIn()) {
            return "in";
        }
        if (p.isValidOut()) {
            return "out";
        }
        return "none";
    });

    private final Class<?> type;
    private final String help;
    private final BiFunction<ValidationsOptions.Builder, String, String> setter;
    private final Function<ValidationsOptions, Object> getter;

    private ValidationsArgument(Class<?> type, String help, BiFunction<ValidationsOptions.Builder, String, String> setter, Function<ValidationsOptions, Object> getter) {
        this.type = type;
        this.help = help;
        this.setter = setter;
        this.getter = getter;
    }

    String setValue(ValidationsOptions.Builder optionBuilder, String value) {
        return this.setter.apply(optionBuilder, value);
    }

    Object getValue(ValidationsOptions options) {
        return this.getter.apply(options);
    }

    String getTypeName() {
        return this.type.getSimpleName();
    }

    String withValue(String value) {
        return "-XJsr303Annotations:" + this.name() + "=" + value;
    }

    String fullOptionName() {
        return "-XJsr303Annotations:" + this.name();
    }

    String fullName() {
        return "XJsr303Annotations:" + this.name();
    }

    public static String getUsageHelp() {
        return "  -" + "-XJsr303Annotations" + "      :  " + "inject Bean validation annotations (JSR 303)" + System.lineSeparator() + "   Options:" + ValidationsArgument.helpMessageWithPrefix("     ") + System.lineSeparator();
    }

    static ValidationsArgument parse(String name) throws BadCommandLineException {
        ValidationsArgument argument = ValidationsArgument.valueOf(name);
        if (argument == null) {
            throw new BadCommandLineException("XJsr303Annotations unrecognized option " + name + ", usage:\n" + ValidationsArgument.helpMessageWithPrefix(""));
        }
        return argument;
    }

    public static String helpMessageWithPrefix(String linePrefix) {
        StringBuilder buf = new StringBuilder();
        for (ValidationsArgument a : ValidationsArgument.values()) {
            buf.append(linePrefix).append(a.name()).append(": ").append("(").append(a.type.getSimpleName()).append(") ").append(a.help).append(System.lineSeparator());
        }
        return buf.toString();
    }

    public String errorMessage(String wrongValue) {
        return this.fullName() + " option expected a value of type " + this.type.getSimpleName() + " but got '" + Objects.toString(wrongValue) + "'";
    }

    static String setBoolean(String value, Consumer<Boolean> setter) {
        if (value == null || "".equals(value.trim())) {
            setter.accept(true);
            return null;
        }
        Boolean bool = ValidationsArgument.toBoolean(value);
        if (bool == null) {
            return "argument not valid, must be 'true' or 'false'";
        }
        setter.accept(bool);
        return null;
    }

    static boolean toBoolean(String v, Boolean defaultIfNull) {
        if (v != null) {
            return ValidationsArgument.toBoolean(v);
        }
        return defaultIfNull != null ? defaultIfNull : false;
    }

    static Boolean toBoolean(String v) {
        if (v != null) {
            String lc = v.toLowerCase().trim();
            if ("true".equals(lc)) {
                return Boolean.TRUE;
            }
            if ("false".equals(lc)) {
                return Boolean.FALSE;
            }
        }
        return null;
    }
}

