/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.krasa.validations;

import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.addon.krasa.JaxbValidationsPlugin;
import com.sun.tools.xjc.addon.krasa.validations.ValidationsAnnotation;
import com.sun.tools.xjc.addon.krasa.validations.ValidationsArgument;
import java.util.Objects;

public class ValidationsOptions {
    private final String targetNamespace;
    private final boolean multiPattern;
    private final boolean verbose;
    private final boolean allNumericConstraints;
    private final boolean notNullAnnotations;
    private final boolean notNullCustomMessage;
    private final boolean notNullPrefixFieldName;
    private final boolean notNullPrefixClassName;
    private final String notNullCustomMessageText;
    private final boolean validationCollection;
    private final ValidationsAnnotation annotationFactory;
    private final boolean validIn;
    private final boolean validOut;

    public void logActualOptions() {
        if (this.verbose) {
            System.out.println(this.getActualOptionValuesAsString());
        }
    }

    private String getActualOptionValuesAsString() {
        String linePrefix = "    ";
        StringBuilder buf = new StringBuilder();
        buf.append("[info] ").append("XJsr303Annotations").append(" options:").append(System.lineSeparator());
        for (ValidationsArgument a : ValidationsArgument.values()) {
            buf.append(linePrefix).append(a.name()).append(": ").append(Objects.toString(a.getValue(this))).append(System.lineSeparator());
        }
        return buf.toString();
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public boolean isMultiPattern() {
        return this.multiPattern;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isAllNumericConstraints() {
        return this.allNumericConstraints;
    }

    public boolean isNotNullAnnotations() {
        return this.notNullAnnotations;
    }

    public boolean isNotNullCustomMessage() {
        return this.notNullCustomMessage;
    }

    public boolean isNotNullPrefixFieldName() {
        return this.notNullPrefixFieldName;
    }

    public boolean isNotNullPrefixClassName() {
        return this.notNullPrefixClassName;
    }

    public String getNotNullCustomMessageText() {
        return this.notNullCustomMessageText;
    }

    public boolean isValidationCollection() {
        return this.validationCollection;
    }

    public ValidationsAnnotation getAnnotationFactory() {
        return this.annotationFactory;
    }

    public boolean isValidIn() {
        return this.validIn;
    }

    public boolean isValidOut() {
        return this.validOut;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ValidationsOptions(String targetNamespace, boolean multiPattern, boolean verbose, boolean allNumericConstraints, boolean notNullAnnotations, boolean notNullCustomMessage, boolean notNullPrefixFieldName, boolean notNullPrefixClassName, String notNullCustomMessageText, boolean validationCollection, ValidationsAnnotation annotationFactory, boolean validIn, boolean validOut) {
        this.targetNamespace = targetNamespace;
        this.multiPattern = multiPattern;
        this.verbose = verbose;
        this.allNumericConstraints = allNumericConstraints;
        this.notNullAnnotations = notNullAnnotations;
        this.notNullCustomMessage = notNullCustomMessage;
        this.notNullPrefixFieldName = notNullPrefixFieldName;
        this.notNullPrefixClassName = notNullPrefixClassName;
        this.notNullCustomMessageText = notNullCustomMessageText;
        this.validationCollection = validationCollection;
        this.annotationFactory = annotationFactory;
        this.validIn = validIn;
        this.validOut = validOut;
    }

    public static class Builder {
        private String targetNamespace = null;
        private boolean multiPattern = false;
        private boolean verbose = false;
        private boolean allNumericConstraints = false;
        private boolean notNullAnnotations = true;
        private boolean notNullCustomMessage = false;
        private boolean notNullPrefixFieldName = false;
        private boolean notNullPrefixClassName = false;
        private String notNullCustomMessageText = null;
        private boolean validationCollection = false;
        private ValidationsAnnotation annotationFactory = ValidationsAnnotation.JAVAX;
        private boolean validIn = true;
        private boolean validOut = true;

        private Builder() {
        }

        public int parseArgument(String option) throws BadCommandLineException {
            if (option.startsWith("-XJsr303Annotations")) {
                int idx = option.indexOf("=");
                if (idx != -1) {
                    String name = option.substring(JaxbValidationsPlugin.PLUGIN_OPTION_NAME_LENGHT, idx);
                    String value = option.substring(idx + 1);
                    ValidationsArgument argument = ValidationsArgument.parse(name);
                    this.setValue(argument, value);
                } else if (option.length() > JaxbValidationsPlugin.PLUGIN_OPTION_NAME_LENGHT) {
                    String name = option.substring(JaxbValidationsPlugin.PLUGIN_OPTION_NAME_LENGHT);
                    ValidationsArgument argument = ValidationsArgument.parse(name);
                    this.setValue(argument, "true");
                }
                return 1;
            }
            return 0;
        }

        private void setValue(ValidationsArgument argument, String value) throws BadCommandLineException {
            try {
                String error = argument.setValue(this, value);
                if (error != null) {
                    throw new BadCommandLineException("option " + argument.name() + ": " + (error.length() > 0 ? error + ", " : "") + "cannot accept '" + value + "' as a " + argument.getTypeName());
                }
            }
            catch (NullPointerException ex) {
                throw new BadCommandLineException(argument.errorMessage(value));
            }
        }

        public Builder targetNamespace(String value) {
            this.targetNamespace = value;
            return this;
        }

        public Builder multiPattern(boolean value) {
            this.multiPattern = value;
            return this;
        }

        public Builder verbose(boolean value) {
            this.verbose = value;
            return this;
        }

        public Builder notNullAnnotations(boolean value) {
            this.notNullAnnotations = value;
            return this;
        }

        public Builder allNumericConstraints(boolean value) {
            this.allNumericConstraints = value;
            return this;
        }

        public Builder notNullCustomMessage(boolean value) {
            this.notNullCustomMessage = value;
            return this;
        }

        public Builder notNullPrefixFieldName(boolean value) {
            this.notNullPrefixFieldName = value;
            return this;
        }

        public Builder notNullPrefixClassName(boolean value) {
            this.notNullPrefixClassName = value;
            return this;
        }

        public Builder notNullCustomMessageText(String value) {
            this.notNullCustomMessageText = value;
            return this;
        }

        public Builder validationCollection(boolean value) {
            this.validationCollection = value;
            return this;
        }

        public Builder annotationFactory(ValidationsAnnotation value) {
            this.annotationFactory = value;
            return this;
        }

        public Builder validIn(boolean value) {
            this.validIn = value;
            return this;
        }

        public Builder validOut(boolean value) {
            this.validOut = value;
            return this;
        }

        public ValidationsOptions build() {
            return new ValidationsOptions(this.targetNamespace, this.multiPattern, this.verbose, this.allNumericConstraints, this.notNullAnnotations, this.notNullCustomMessage, this.notNullPrefixFieldName, this.notNullPrefixClassName, this.notNullCustomMessageText, this.validationCollection, this.annotationFactory, this.validIn, this.validOut);
        }
    }
}

