/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.krasa.validations;

import com.sun.tools.xjc.addon.krasa.validations.AbstractFacet;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSSimpleType;
import java.math.BigDecimal;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

class XSSimpleTypeFacet
extends AbstractFacet {
    private final XSSimpleType simpleType;

    public XSSimpleTypeFacet(XSSimpleType simpleType) {
        this.simpleType = simpleType;
    }

    @Override
    public Integer minLength() {
        return this.getIntegerFacet("minLength");
    }

    @Override
    public Integer maxLength() {
        return this.getIntegerFacet("maxLength");
    }

    @Override
    public Integer length() {
        return this.getIntegerFacet("length");
    }

    @Override
    public Integer totalDigits() {
        return this.getIntegerFacet("totalDigits");
    }

    @Override
    public Integer fractionDigits() {
        return this.getIntegerFacet("fractionDigits");
    }

    @Override
    public BigDecimal minInclusive() {
        return this.getDecimalFacet("minInclusive");
    }

    @Override
    public BigDecimal minExclusive() {
        return this.getDecimalFacet("minExclusive");
    }

    @Override
    public BigDecimal maxInclusive() {
        return this.getDecimalFacet("maxInclusive");
    }

    @Override
    public BigDecimal maxExclusive() {
        return this.getDecimalFacet("maxExclusive");
    }

    @Override
    public String pattern() {
        return this.getStringFacet("pattern");
    }

    @Override
    public LinkedHashSet<String> patternList() {
        return this.getMultipleStringFacets("pattern");
    }

    @Override
    public String enumeration() {
        return this.getStringFacet("enumeration");
    }

    @Override
    public LinkedHashSet<String> enumerationList() {
        return this.getMultipleStringFacets("enumeration");
    }

    private LinkedHashSet<String> getMultipleStringFacets(String param) {
        List facets = this.simpleType.getFacets(param);
        if (facets != null) {
            return facets.stream().map(facet -> facet.getValue().value).filter(v -> v != null && !v.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        return new LinkedHashSet<String>();
    }

    private String getStringFacet(String param) {
        XSFacet facet = this.simpleType.getFacet(param);
        return facet == null ? null : facet.getValue().value;
    }

    private Integer getIntegerFacet(String param) {
        XSFacet facet = this.simpleType.getFacet(param);
        if (facet != null) {
            try {
                return Integer.valueOf(facet.getValue().value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private BigDecimal getDecimalFacet(String param) {
        XSFacet facet = this.simpleType.getFacet(param);
        if (facet != null) {
            String str = facet.getValue().value;
            try {
                return new BigDecimal(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

