/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.krasa.validations;

import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JFieldVar;
import com.sun.tools.xjc.addon.krasa.validations.ValidationsLogger;
import jakarta.validation.constraints.Pattern;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class XjcAnnotator {
    private final JFieldVar field;
    private final ValidationsLogger logger;
    private final Set<Class<? extends Annotation>> annotationSet = new HashSet<Class<? extends Annotation>>();

    public XjcAnnotator(JFieldVar field, ValidationsLogger logger) {
        this.field = field;
        this.logger = logger;
    }

    Annotate annotate(Class<? extends Annotation> annotation) {
        return new Annotate(annotation);
    }

    public class Annotate {
        private final JAnnotationUse annotationUse;
        private final Map<String, String> parameterMap = new LinkedHashMap<String, String>();

        public Annotate(JAnnotationUse annotationUse) {
            this.annotationUse = annotationUse;
        }

        public Annotate(Class<? extends Annotation> annotation) {
            this.annotationUse = XjcAnnotator.this.annotationSet.add(annotation) || annotation.equals(Pattern.class) || annotation.equals(javax.validation.constraints.Pattern.class) ? XjcAnnotator.this.field.annotate(annotation) : null;
        }

        public Annotate paramIf(boolean condition, String name, Integer value) {
            if (condition && this.annotationUse != null && value != null && !this.parameterMap.containsKey(name)) {
                this.annotationUse.param(name, value.intValue());
                this.parameterMap.put(name, value.toString());
            }
            return this;
        }

        public Annotate param(String name, Integer value) {
            if (this.annotationUse != null && value != null && !this.parameterMap.containsKey(name)) {
                this.annotationUse.param(name, value.intValue());
                this.parameterMap.put(name, value.toString());
            }
            return this;
        }

        public Annotate param(String name, Boolean value) {
            if (this.annotationUse != null && value != null && !this.parameterMap.containsKey(name)) {
                this.annotationUse.param(name, value.booleanValue());
                this.parameterMap.put(name, value.toString());
            }
            return this;
        }

        public Annotate param(String name, BigDecimal value) {
            if (this.annotationUse != null && value != null && !this.parameterMap.containsKey(name)) {
                this.annotationUse.param(name, value.toString());
                this.parameterMap.put(name, value.toString());
            }
            return this;
        }

        public Annotate param(String name, String value) {
            if (this.annotationUse != null && value != null && !this.parameterMap.containsKey(name)) {
                this.annotationUse.param(name, value);
                this.parameterMap.put(name, value);
            }
            return this;
        }

        public Annotate param(String name, String value, String defaultValue) {
            if (this.annotationUse != null && !this.parameterMap.containsKey(name)) {
                String v = value == null ? defaultValue : value;
                this.annotationUse.param(name, v);
                this.parameterMap.put(name, v);
            }
            return this;
        }

        public Annotate param(String name, Integer value, Integer defaultValue) {
            if (this.annotationUse != null && !this.parameterMap.containsKey(name)) {
                Integer v = value == null ? defaultValue : value;
                this.annotationUse.param(name, v.intValue());
                this.parameterMap.put(name, v.toString());
            }
            return this;
        }

        public void log() {
            if (this.annotationUse != null) {
                String annotationName = this.annotationUse.getAnnotationClass().name();
                XjcAnnotator.this.logger.addAnnotation(annotationName, this.parameterMap);
            }
        }

        public MultipleAnnotation multipleAnnotationContainer(String paramName) {
            JAnnotationArrayMember array = this.annotationUse.paramArray(paramName);
            return new MultipleAnnotation(array);
        }

        public class MultipleAnnotation {
            private final JAnnotationArrayMember array;

            public MultipleAnnotation(JAnnotationArrayMember array) {
                this.array = array;
            }

            public Annotate annotate(Class<? extends Annotation> annotationClass) {
                JAnnotationUse annotationUse = this.array.annotate(annotationClass);
                return new Annotate(annotationUse);
            }
        }
    }
}

