/*
 * Decompiled with CFR 0.152.
 */
package com.fing.compression.fourmc;

import com.fing.compression.fourmc.FourMcInputStream;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class FourMcBlockIndex {
    public static final long NOT_FOUND = -1L;
    private long[] blockOffsets;

    public FourMcBlockIndex() {
    }

    public FourMcBlockIndex(int blocks) {
        this.blockOffsets = new long[blocks];
    }

    public void set(int blockNo, long offset) {
        this.blockOffsets[blockNo] = offset;
    }

    public int getNumberOfBlocks() {
        return this.blockOffsets.length;
    }

    public long getPosition(int block) {
        return this.blockOffsets[block];
    }

    public long findNextPosition(long pos) {
        int block = Arrays.binarySearch(this.blockOffsets, pos);
        if (block >= 0) {
            return this.blockOffsets[block];
        }
        if ((block = -block - 1) > this.blockOffsets.length - 1) {
            return -1L;
        }
        return this.blockOffsets[block];
    }

    public long findBelongingBlockIndex(long pos) {
        int block = Arrays.binarySearch(this.blockOffsets, pos);
        if (block >= 0) {
            return block;
        }
        if ((block = -block - 1 - 1) > this.blockOffsets.length - 1 || block < 0) {
            return -1L;
        }
        return block;
    }

    public boolean isEmpty() {
        return this.blockOffsets == null || this.blockOffsets.length == 0;
    }

    public long alignSliceStartToIndex(long start, long end) {
        if (start != 0L) {
            long newStart = this.findNextPosition(start);
            if (newStart == -1L || newStart >= end) {
                return -1L;
            }
            start = newStart;
        }
        return start;
    }

    public long alignSliceEndToIndex(long end, long fileSize) {
        long newEnd = this.findNextPosition(end);
        end = newEnd != -1L ? newEnd : fileSize;
        return end;
    }

    public static FourMcBlockIndex readIndex(FileSystem fs, Path file) throws IOException {
        return FourMcInputStream.readIndex(fs, file);
    }
}

