/*
 * Decompiled with CFR 0.152.
 */
package com.fing.compression.fourmc;

import com.fing.compression.fourmc.FourMcInputStream;
import com.fing.compression.fourmc.FourMcOutputStream;
import com.fing.compression.fourmc.Lz4Codec;
import com.fing.compression.fourmc.Lz4Compressor;
import com.fing.compression.fourmc.Lz4Decompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;

public class FourMcCodec
extends Lz4Codec {
    public static final int FOURMC_MAGIC = 877478656;
    public static final int FOURMC_VERSION = 1;
    public static final int FOURMC_MAX_BLOCK_SIZE = 0x400000;
    public static final String FOURMC_DEFAULT_EXTENSION = ".4mc";
    public static final String FOURMC_BLOCK_SIZE_KEY = "io.compression.codec.4mc.blocksize";

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return this.createOutputStream(out, this.createCompressor());
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        if (!FourMcCodec.isNativeLoaded(this.getConf())) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return new FourMcOutputStream(out, compressor, 0x400000);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        if (!FourMcCodec.isNativeLoaded(this.getConf())) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return new FourMcInputStream(in, decompressor, 0x400000);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, this.createDecompressor());
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        if (!FourMcCodec.isNativeLoaded(this.getConf())) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return Lz4Decompressor.class;
    }

    @Override
    public Decompressor createDecompressor() {
        if (!FourMcCodec.isNativeLoaded(this.getConf())) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return new Lz4Decompressor(0x400000);
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        if (!FourMcCodec.isNativeLoaded(this.getConf())) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return Lz4Compressor.class;
    }

    @Override
    public Compressor createCompressor() {
        assert (this.getConf() != null) : "Configuration cannot be null! You must call setConf() before creating a compressor.";
        if (!FourMcCodec.isNativeLoaded(this.getConf())) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return new Lz4Compressor(this.getCompressionBlockSize());
    }

    @Override
    public String getDefaultExtension() {
        return FOURMC_DEFAULT_EXTENSION;
    }

    protected int getCompressionBlockSize() {
        return 0x400000;
    }
}

