/*
 * Decompiled with CFR 0.152.
 */
package com.fing.compression.fourmc;

import com.fing.compression.fourmc.FourMcBlockIndex;
import com.fing.compression.fourmc.FourMcNativeCodeLoader;
import com.fing.compression.fourmc.Lz4Decompressor;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.Decompressor;

public class FourMcInputStream
extends BlockDecompressorStream {
    private static final Log LOG = LogFactory.getLog(FourMcInputStream.class);
    private final byte[] buf = new byte[12];
    private int noUncompressedBytes = 0;
    private int noCompressedBytes = 0;
    private int uncompressedBlockSize = 0;

    public FourMcInputStream(InputStream in, Decompressor decompressor, int bufferSize) throws IOException {
        super(in, decompressor, bufferSize);
        try {
            this.readHeader(in);
        }
        catch (IOException e) {
            ((Lz4Decompressor)this.decompressor).releaseDirectBuffers();
            this.decompressor = null;
            throw e;
        }
    }

    private static void readFully(InputStream in, byte[] buf, int off, int len) throws IOException, EOFException {
        int toRead = len;
        while (toRead > 0) {
            int ret = in.read(buf, off, toRead);
            if (ret < 0) {
                throw new EOFException("Premature EOF from inputStream");
            }
            toRead -= ret;
            off += ret;
        }
    }

    private static int readInt(InputStream in, byte[] buf, int len) throws IOException {
        FourMcInputStream.readFully(in, buf, 0, len);
        int ret = (0xFF & buf[0]) << 24;
        ret |= (0xFF & buf[1]) << 16;
        ret |= (0xFF & buf[2]) << 8;
        return len > 3 ? ret : (ret |= 0xFF & buf[3]) >>> 8 * (4 - len);
    }

    private static int getInt(byte[] buf, int offset) throws IOException {
        int ret = (0xFF & buf[offset]) << 24;
        ret |= (0xFF & buf[offset + 1]) << 16;
        ret |= (0xFF & buf[offset + 2]) << 8;
        return ret |= 0xFF & buf[offset + 3];
    }

    protected void readHeader(InputStream in) throws IOException {
        FourMcInputStream.readFully(in, this.buf, 0, 12);
        int magic = FourMcInputStream.getInt(this.buf, 0);
        if (magic != 877478656) {
            throw new IOException("Invalid 4mc header (wrong magic)");
        }
        int version = FourMcInputStream.getInt(this.buf, 4);
        if (version != 1) {
            throw new IOException("Invalid 4mc header (wrong version)");
        }
        int hdrChecksum = FourMcInputStream.getInt(this.buf, 8);
        if (hdrChecksum != Lz4Decompressor.xxhash32(this.buf, 0, 8, 0)) {
            throw new IOException("Invalid 4mc header (invalid checksum)");
        }
    }

    public static FourMcBlockIndex readIndex(FileSystem fs, Path file) throws IOException {
        long fileSize = fs.getFileStatus(file).getLen();
        if (fileSize < 32L) {
            return new FourMcBlockIndex();
        }
        FSDataInputStream indexIn = fs.open(file);
        int readTailSize = 4096;
        if ((long)readTailSize > fileSize - 12L) {
            readTailSize = (int)(fileSize - 12L);
        }
        indexIn.seek(fileSize - (long)readTailSize);
        byte[] buf = new byte[readTailSize];
        FourMcInputStream.readFully((InputStream)indexIn, buf, 0, buf.length);
        int footerSize = FourMcInputStream.getInt(buf, buf.length - 12);
        int magic = FourMcInputStream.getInt(buf, buf.length - 8);
        int checksum = FourMcInputStream.getInt(buf, buf.length - 4);
        if (magic != 877478656) {
            throw new IOException("Invalid 4mc footer magic");
        }
        if ((long)footerSize >= fileSize - 12L) {
            throw new IOException("Invalid 4mc footer checksum");
        }
        if (footerSize > readTailSize) {
            readTailSize = footerSize;
            indexIn.seek(fileSize - (long)readTailSize);
            buf = new byte[readTailSize];
            FourMcInputStream.readFully((InputStream)indexIn, buf, 0, buf.length);
        }
        indexIn.close();
        int startFooterOffset = readTailSize - footerSize;
        if (FourMcInputStream.getInt(buf, startFooterOffset) != footerSize) {
            throw new IOException("Invalid 4mc footer size");
        }
        if (FourMcInputStream.getInt(buf, startFooterOffset + 4) != 1) {
            throw new IOException("Invalid 4mc footer version (" + FourMcInputStream.getInt(buf, startFooterOffset + 4) + ")");
        }
        if (checksum != Lz4Decompressor.xxhash32(buf, startFooterOffset, footerSize - 4, 0)) {
            throw new IOException("Invalid 4mc footer checksum");
        }
        int totalBlocks = (footerSize - 20) / 4;
        FourMcBlockIndex index = new FourMcBlockIndex(totalBlocks);
        long curOffset = 0L;
        for (int i = 0; i < totalBlocks; ++i) {
            index.set(i, curOffset += (long)FourMcInputStream.getInt(buf, startFooterOffset + 8 + i * 4));
        }
        return index;
    }

    protected int decompress(byte[] b, int off, int len) throws IOException {
        if (this.noUncompressedBytes == this.uncompressedBlockSize) {
            try {
                byte[] tempBuf = new byte[4];
                this.uncompressedBlockSize = FourMcInputStream.readInt(this.in, tempBuf, 4);
                this.noCompressedBytes += 4;
            }
            catch (EOFException e) {
                return -1;
            }
            this.noUncompressedBytes = 0;
        }
        int n = 0;
        while ((n = this.decompressor.decompress(b, off, len)) == 0) {
            if ((this.decompressor.finished() || this.decompressor.needsDictionary()) && this.noUncompressedBytes >= this.uncompressedBlockSize) {
                this.eof = true;
                return -1;
            }
            if (!this.decompressor.needsInput()) continue;
            try {
                this.getCompressedData();
            }
            catch (EOFException e) {
                this.eof = true;
                return -1;
            }
            catch (IOException e) {
                LOG.warn((Object)"IOException in getCompressedData; likely 4mc corruption.", (Throwable)e);
                throw e;
            }
        }
        this.noUncompressedBytes += n;
        return n;
    }

    protected int getCompressedData() throws IOException {
        this.checkStream();
        int compressedLen = FourMcInputStream.readInt(this.in, this.buf, 4);
        this.noCompressedBytes += 4;
        int checksum = FourMcInputStream.readInt(this.in, this.buf, 4);
        this.noCompressedBytes += 4;
        if (compressedLen > 0x400000) {
            throw new IOException("Compressed length " + compressedLen + " exceeds max block size " + 0x400000);
        }
        Lz4Decompressor lz4dec = (Lz4Decompressor)this.decompressor;
        lz4dec.setCurrentBlockUncompressed(compressedLen >= this.uncompressedBlockSize);
        if (compressedLen > this.buffer.length) {
            this.buffer = new byte[compressedLen];
        }
        FourMcInputStream.readFully(this.in, this.buffer, 0, compressedLen);
        this.noCompressedBytes += compressedLen;
        if (checksum != Lz4Decompressor.xxhash32(this.buffer, 0, compressedLen, 0)) {
            if (lz4dec.isCurrentBlockUncompressed()) {
                throw new IOException("Corrupted uncompressed block (invalid checksum)");
            }
            throw new IOException("Corrupted compressed block (invalid checksum)");
        }
        lz4dec.setInput(this.buffer, 0, compressedLen);
        return compressedLen;
    }

    public long getCompressedBytesRead() {
        return this.noCompressedBytes;
    }

    public void close() throws IOException {
        if (this.decompressor == null) {
            return;
        }
        byte[] b = new byte[4096];
        while (!this.decompressor.finished()) {
            this.decompressor.decompress(b, 0, b.length);
        }
        super.close();
        ((Lz4Decompressor)this.decompressor).releaseDirectBuffers();
        this.decompressor = null;
    }

    static {
        if (FourMcNativeCodeLoader.isNativeCodeLoaded()) {
            boolean nativeLoaded = Lz4Decompressor.isNativeLoaded();
            if (!nativeLoaded) {
                LOG.error((Object)"Failed to load/initialize native-4mc library");
            }
        } else {
            LOG.error((Object)"Cannot load native-4mc without native-hadoop");
        }
    }
}

