/*
 * Decompiled with CFR 0.152.
 */
package com.fing.compression.fourmc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FourMcNativeCodeLoader {
    private static final Log LOG = LogFactory.getLog(FourMcNativeCodeLoader.class);
    private static boolean nativeLibraryLoaded = false;
    public static final String USE_BINARIES_ON_LIB_PATH = "com.fing.compression.fourmc.use.libpath";

    private static String arch() {
        return System.getProperty("os.arch");
    }

    private static OS os() {
        String osName = System.getProperty("os.name");
        if (osName.contains("Linux")) {
            return OS.LINUX;
        }
        if (osName.contains("Mac")) {
            return OS.MAC;
        }
        if (osName.contains("Windows")) {
            return OS.WINDOWS;
        }
        if (osName.contains("Solaris") || osName.contains("SunOS")) {
            return OS.SOLARIS;
        }
        throw new UnsupportedOperationException("hadoop-4mc: Unsupported operating system: " + osName);
    }

    private static String resourceName() {
        OS os = FourMcNativeCodeLoader.os();
        String packagePrefix = FourMcNativeCodeLoader.class.getPackage().getName().replace('.', '/');
        return "/" + packagePrefix + "/" + os.name + "/" + FourMcNativeCodeLoader.arch() + "/libhadoop-4mc." + os.libExtension;
    }

    private static boolean useBinariesOnLibPath() {
        return Boolean.getBoolean(USE_BINARIES_ON_LIB_PATH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void loadLibrary() {
        if (nativeLibraryLoaded) {
            LOG.info((Object)"hadoop-4mc: native library is already loaded");
            return;
        }
        if (FourMcNativeCodeLoader.useBinariesOnLibPath()) {
            try {
                System.loadLibrary("hadoop-4mc");
                nativeLibraryLoaded = true;
                LOG.info((Object)"hadoop-4mc: loaded native library (lib-path)");
            }
            catch (Exception e) {
                LOG.error((Object)"hadoop-4mc: cannot load native library (lib-path): ", (Throwable)e);
            }
            return;
        }
        String resourceName = FourMcNativeCodeLoader.resourceName();
        InputStream is = FourMcNativeCodeLoader.class.getResourceAsStream(resourceName);
        if (is == null) {
            throw new UnsupportedOperationException("Unsupported OS/arch, cannot find " + resourceName + ". Please try building from source.");
        }
        try {
            File tempLib = File.createTempFile("libhadoop-4mc", "." + FourMcNativeCodeLoader.os().libExtension);
            FileOutputStream out = new FileOutputStream(tempLib);
            try {
                int read;
                byte[] buf = new byte[4096];
                while ((read = is.read(buf)) != -1) {
                    out.write(buf, 0, read);
                }
                try {
                    out.close();
                    out = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                System.load(tempLib.getAbsolutePath());
                nativeLibraryLoaded = true;
                LOG.info((Object)"hadoop-4mc: loaded native library (embedded)");
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
                if (tempLib.exists()) {
                    if (!nativeLibraryLoaded) {
                        tempLib.delete();
                    } else {
                        tempLib.deleteOnExit();
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"hadoop-4mc: cannot load native library  (embedded): ", (Throwable)e);
        }
    }

    public static boolean isNativeCodeLoaded() {
        return nativeLibraryLoaded;
    }

    static {
        FourMcNativeCodeLoader.loadLibrary();
    }

    private static enum OS {
        WINDOWS("win32", "dll"),
        LINUX("linux", "so"),
        MAC("darwin", "dylib"),
        SOLARIS("solaris", "so");

        public final String name;
        public final String libExtension;

        private OS(String name, String libExtension) {
            this.name = name;
            this.libExtension = libExtension;
        }
    }
}

