/*
 * Decompiled with CFR 0.152.
 */
package com.fing.compression.fourmc;

import com.fing.compression.fourmc.FourMcNativeCodeLoader;
import com.fing.compression.fourmc.Lz4Compressor;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.CompressorStream;

public class FourMcOutputStream
extends CompressorStream {
    private static final Log LOG = LogFactory.getLog(FourMcOutputStream.class);
    private List<Long> blockOffsets;
    private CountingOutputStream cout;

    protected static void write4mcHeader(OutputStream out) throws IOException {
        try (DataOutputBuffer dob = new DataOutputBuffer();){
            dob.writeInt(877478656);
            dob.writeInt(1);
            int checksum = Lz4Compressor.xxhash32(dob.getData(), 0, 8, 0);
            dob.writeInt(checksum);
            out.write(dob.getData(), 0, dob.getLength());
        }
    }

    public FourMcOutputStream(OutputStream out, Compressor compressor, int bufferSize) throws IOException {
        super((OutputStream)new CountingOutputStream(out), compressor, bufferSize);
        this.cout = (CountingOutputStream)this.out;
        this.blockOffsets = new ArrayList<Long>(32);
        try {
            FourMcOutputStream.write4mcHeader(this.out);
        }
        catch (IOException e) {
            ((Lz4Compressor)this.compressor).releaseDirectBuffers();
            this.compressor = null;
            throw e;
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.finish();
        this.rawWriteInt(0);
        this.rawWriteInt(0);
        this.rawWriteInt(0);
        int footerSize = 20 + this.blockOffsets.size() * 4;
        DataOutputBuffer dob = new DataOutputBuffer();
        dob.writeInt(footerSize);
        dob.writeInt(1);
        for (int i = 0; i < this.blockOffsets.size(); ++i) {
            long blockDelta = i == 0 ? this.blockOffsets.get(i) : this.blockOffsets.get(i) - this.blockOffsets.get(i - 1);
            dob.writeInt((int)blockDelta);
        }
        dob.writeInt(footerSize);
        dob.writeInt(877478656);
        int checksum = Lz4Compressor.xxhash32(dob.getData(), 0, dob.getLength(), 0);
        dob.writeInt(checksum);
        this.out.write(dob.getData(), 0, dob.getLength());
        this.out.close();
        this.closed = true;
        ((Lz4Compressor)this.compressor).releaseDirectBuffers();
        this.compressor = null;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.compressor.finished()) {
            throw new IOException("write beyond end of stream");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        long limlen = this.compressor.getBytesRead();
        if ((long)len + limlen > 0x400000L && limlen > 0L) {
            this.finish();
            this.compressor.reset();
        }
        if (len > 0x400000) {
            int bufLen;
            do {
                bufLen = Math.min(len, 0x400000);
                this.compressor.setInput(b, off, bufLen);
                this.finish();
                this.compressor.reset();
                off += bufLen;
            } while ((len -= bufLen) > 0);
            return;
        }
        this.compressor.setInput(b, off, len);
        if (!this.compressor.needsInput()) {
            do {
                this.compress();
            } while (!this.compressor.needsInput());
        }
    }

    public void finish() throws IOException {
        if (!this.compressor.finished()) {
            this.compressor.finish();
            while (!this.compressor.finished()) {
                this.compress();
            }
        }
    }

    protected void compress() throws IOException {
        int len = this.compressor.compress(this.buffer, 0, this.buffer.length);
        if (len > 0) {
            this.blockOffsets.add(this.cout.bytesWritten);
            this.rawWriteInt((int)this.compressor.getBytesRead());
            if (this.compressor.getBytesRead() <= this.compressor.getBytesWritten()) {
                byte[] uncompressed = ((Lz4Compressor)this.compressor).uncompressedBytes();
                this.rawWriteInt(uncompressed.length);
                int checksum = Lz4Compressor.xxhash32(uncompressed, 0, uncompressed.length, 0);
                this.rawWriteInt(checksum);
                this.out.write(uncompressed, 0, uncompressed.length);
                this.compressor.reset();
                this.compressor.finish();
            } else {
                this.rawWriteInt(len);
                int checksum = Lz4Compressor.xxhash32(this.buffer, 0, len, 0);
                this.rawWriteInt(checksum);
                this.out.write(this.buffer, 0, len);
            }
        }
    }

    private void rawWriteInt(int v) throws IOException {
        this.out.write(v >>> 24 & 0xFF);
        this.out.write(v >>> 16 & 0xFF);
        this.out.write(v >>> 8 & 0xFF);
        this.out.write(v & 0xFF);
    }

    static {
        if (FourMcNativeCodeLoader.isNativeCodeLoaded()) {
            boolean nativeLoaded = Lz4Compressor.isNativeLoaded();
            if (!nativeLoaded) {
                LOG.error((Object)"Failed to load/initialize native-4mc library");
            }
        } else {
            LOG.error((Object)"Cannot load native-4mc without native-hadoop");
        }
    }

    private static class CountingOutputStream
    extends FilterOutputStream {
        long bytesWritten = 0L;

        public CountingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
            this.bytesWritten += (long)len;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            ++this.bytesWritten;
        }
    }
}

