/*
 * Decompiled with CFR 0.152.
 */
package com.fing.compression.fourmc;

import com.fing.compression.fourmc.FourMzInputStream;
import com.fing.compression.fourmc.FourMzOutputStream;
import com.fing.compression.fourmc.ZstdCodec;
import com.fing.compression.fourmc.ZstdCompressor;
import com.fing.compression.fourmc.ZstdDecompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;

public class FourMzCodec
extends ZstdCodec {
    public static final int FOURMZ_MAGIC = 877484544;
    public static final int FOURMZ_VERSION = 1;
    public static final int FOURMC_MAX_BLOCK_SIZE = 0x400000;
    public static final String FOURMZ_DEFAULT_EXTENSION = ".4mz";
    public static final String FOURMZ_BLOCK_SIZE_KEY = "io.compression.codec.4mz.blocksize";

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return this.createOutputStream(out, this.createCompressor());
    }

    @Override
    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        if (!FourMzCodec.isNativeLoaded(this.getConf())) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return new FourMzOutputStream(out, compressor, 0x400000);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        if (!FourMzCodec.isNativeLoaded(this.getConf())) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return new FourMzInputStream(in, decompressor, 0x400000);
    }

    @Override
    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, this.createDecompressor());
    }

    @Override
    public Class<? extends Decompressor> getDecompressorType() {
        if (!FourMzCodec.isNativeLoaded(this.getConf())) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return ZstdDecompressor.class;
    }

    @Override
    public Decompressor createDecompressor() {
        if (!FourMzCodec.isNativeLoaded(this.getConf())) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return new ZstdDecompressor(0x400000);
    }

    @Override
    public Class<? extends Compressor> getCompressorType() {
        if (!FourMzCodec.isNativeLoaded(this.getConf())) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return ZstdCompressor.class;
    }

    @Override
    public Compressor createCompressor() {
        assert (this.getConf() != null) : "Configuration cannot be null! You must call setConf() before creating a compressor.";
        if (!FourMzCodec.isNativeLoaded(this.getConf())) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return new ZstdCompressor(this.getCompressionBlockSize());
    }

    @Override
    public String getDefaultExtension() {
        return FOURMZ_DEFAULT_EXTENSION;
    }

    protected int getCompressionBlockSize() {
        return 0x400000;
    }
}

