/*
 * Decompiled with CFR 0.152.
 */
package com.fing.compression.fourmc;

import com.fing.compression.fourmc.FourMcNativeCodeLoader;
import com.fing.compression.fourmc.util.DirectBufferPool;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.compress.Decompressor;

public class Lz4Decompressor
implements Decompressor {
    private static final Log LOG = LogFactory.getLog((String)Lz4Decompressor.class.getName());
    private int directBufferSize;
    private Buffer compressedDirectBuf = null;
    private int compressedDirectBufLen;
    private Buffer uncompressedDirectBuf = null;
    private byte[] userBuf = null;
    private int userBufOff = 0;
    private int userBufLen = 0;
    private boolean finished;
    private boolean isCurrentBlockUncompressed;
    private static boolean nativeLoaded;

    public static boolean isNativeLoaded() {
        return nativeLoaded;
    }

    public Lz4Decompressor(int directBufferSize) {
        this.directBufferSize = directBufferSize;
        this.compressedDirectBuf = DirectBufferPool.getInstance().allocate(directBufferSize);
        this.uncompressedDirectBuf = DirectBufferPool.getInstance().allocate(directBufferSize);
        this.uncompressedDirectBuf.position(directBufferSize);
    }

    public Lz4Decompressor() {
        this(0x400000);
    }

    public synchronized void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.userBuf = b;
        this.userBufOff = off;
        this.userBufLen = len;
        this.setInputFromSavedData();
        this.uncompressedDirectBuf.limit(this.directBufferSize);
        this.uncompressedDirectBuf.position(this.directBufferSize);
    }

    synchronized void setInputFromSavedData() {
        if (!this.isCurrentBlockUncompressed()) {
            this.compressedDirectBufLen = Math.min(this.userBufLen, this.directBufferSize);
            this.compressedDirectBuf.rewind();
            ((ByteBuffer)this.compressedDirectBuf).put(this.userBuf, this.userBufOff, this.compressedDirectBufLen);
            this.userBufOff += this.compressedDirectBufLen;
            this.userBufLen -= this.compressedDirectBufLen;
        }
    }

    public synchronized void setDictionary(byte[] b, int off, int len) {
    }

    public synchronized boolean needsInput() {
        if (this.uncompressedDirectBuf.remaining() > 0) {
            return false;
        }
        if (this.compressedDirectBufLen <= 0) {
            if (this.userBufLen <= 0) {
                return true;
            }
            this.setInputFromSavedData();
        }
        return false;
    }

    public synchronized boolean needsDictionary() {
        return false;
    }

    public synchronized boolean finished() {
        return this.finished && this.uncompressedDirectBuf.remaining() == 0;
    }

    public synchronized int decompress(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int numBytes = 0;
        if (this.isCurrentBlockUncompressed()) {
            numBytes = Math.min(this.userBufLen, len);
            System.arraycopy(this.userBuf, this.userBufOff, b, off, numBytes);
            this.userBufOff += numBytes;
            this.userBufLen -= numBytes;
        } else {
            numBytes = this.uncompressedDirectBuf.remaining();
            if (numBytes > 0) {
                numBytes = Math.min(numBytes, len);
                ((ByteBuffer)this.uncompressedDirectBuf).get(b, off, numBytes);
                return numBytes;
            }
            if (this.compressedDirectBufLen > 0) {
                this.uncompressedDirectBuf.rewind();
                this.uncompressedDirectBuf.limit(this.directBufferSize);
                numBytes = this.decompressBytesDirect();
                this.uncompressedDirectBuf.limit(numBytes);
                numBytes = Math.min(numBytes, len);
                ((ByteBuffer)this.uncompressedDirectBuf).get(b, off, numBytes);
            }
        }
        if (this.userBufLen <= 0) {
            this.finished = true;
        }
        return numBytes;
    }

    public synchronized int getRemaining() {
        return this.userBufLen;
    }

    public synchronized void reset() {
        this.finished = false;
        this.compressedDirectBufLen = 0;
        this.uncompressedDirectBuf.limit(this.directBufferSize);
        this.uncompressedDirectBuf.position(this.directBufferSize);
        this.userBufLen = 0;
        this.userBufOff = 0;
    }

    public synchronized void end() {
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.end();
        this.releaseDirectBuffers();
    }

    public void releaseDirectBuffers() {
        if (this.compressedDirectBuf != null) {
            DirectBufferPool.getInstance().release((ByteBuffer)this.compressedDirectBuf);
            this.compressedDirectBuf = null;
        }
        if (this.uncompressedDirectBuf != null) {
            DirectBufferPool.getInstance().release((ByteBuffer)this.uncompressedDirectBuf);
            this.uncompressedDirectBuf = null;
        }
    }

    public synchronized void setCurrentBlockUncompressed(boolean uncompressed) {
        this.isCurrentBlockUncompressed = uncompressed;
    }

    protected synchronized boolean isCurrentBlockUncompressed() {
        return this.isCurrentBlockUncompressed;
    }

    private static native void initIDs();

    private native int decompressBytesDirect();

    public static native int xxhash32(byte[] var0, int var1, int var2, int var3);

    static {
        if (FourMcNativeCodeLoader.isNativeCodeLoaded()) {
            try {
                Lz4Decompressor.initIDs();
                nativeLoaded = true;
            }
            catch (Throwable t) {
                LOG.warn((Object)t.toString());
                nativeLoaded = false;
            }
        } else {
            LOG.error((Object)("Cannot load " + Lz4Decompressor.class.getName() + " without native-hadoop library!"));
            nativeLoaded = false;
        }
    }
}

