/*
 * Decompiled with CFR 0.152.
 */
package com.fing.compression.fourmc;

import com.fing.compression.fourmc.FourMcNativeCodeLoader;
import com.fing.compression.fourmc.zstd.ZstdStreamCompressor;
import com.fing.compression.fourmc.zstd.ZstdStreamDecompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.CompressorStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.DecompressorStream;

public class ZstCodec
implements Configurable,
CompressionCodec {
    private static final Log LOG = LogFactory.getLog((String)ZstCodec.class.getName());
    public static final int ZST_BUFFER_SIZE = 262144;
    private Configuration conf;
    private static boolean nativeLoaded = false;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public static boolean isNativeLoaded(Configuration conf) {
        assert (conf != null) : "Configuration cannot be null!";
        return nativeLoaded && conf.getBoolean("hadoop.native.lib", true);
    }

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return this.createOutputStream(out, this.createCompressor());
    }

    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        if (!ZstCodec.isNativeLoaded(this.conf)) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return new CompressorStream(out, compressor, 262144);
    }

    public Class<? extends Compressor> getCompressorType() {
        if (!ZstCodec.isNativeLoaded(this.conf)) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return ZstdStreamCompressor.class;
    }

    public Compressor createCompressor() {
        assert (this.conf != null) : "Configuration cannot be null! You must call setConf() before creating a compressor.";
        if (!ZstCodec.isNativeLoaded(this.conf)) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        int compressionLevel = this.conf.getInt("io.compress.zst.compression.level", 1);
        if (compressionLevel <= 0 || compressionLevel >= 23) {
            compressionLevel = 3;
        }
        return new ZstdStreamCompressor(compressionLevel);
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, this.createDecompressor());
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        if (!ZstCodec.isNativeLoaded(this.conf)) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return new DecompressorStream(in, decompressor, 262144);
    }

    public Class<? extends Decompressor> getDecompressorType() {
        if (!ZstCodec.isNativeLoaded(this.conf)) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return ZstdStreamDecompressor.class;
    }

    public Decompressor createDecompressor() {
        if (!ZstCodec.isNativeLoaded(this.conf)) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return new ZstdStreamDecompressor();
    }

    public String getDefaultExtension() {
        return ".zst";
    }

    static {
        if (FourMcNativeCodeLoader.isNativeCodeLoaded()) {
            boolean bl = nativeLoaded = ZstdStreamCompressor.isNativeLoaded() && ZstdStreamDecompressor.isNativeLoaded();
            if (nativeLoaded) {
                LOG.info((Object)"Successfully loaded & initialized hadoop-4mc library");
            } else {
                LOG.error((Object)"Failed to load/initialize hadoop-4mc library");
            }
        } else {
            LOG.error((Object)"Cannot load hadoop-4mc native library");
        }
    }
}

