/*
 * Decompiled with CFR 0.152.
 */
package com.fing.compression.fourmc;

import com.fing.compression.fourmc.FourMcNativeCodeLoader;
import com.fing.compression.fourmc.util.DirectBufferPool;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.Compressor;

public class ZstdCompressor
implements Compressor {
    private static final Log LOG = LogFactory.getLog((String)ZstdCompressor.class.getName());
    private int directBufferSize;
    private byte[] userBuf = null;
    private int userBufOff = 0;
    private int userBufLen = 0;
    private ByteBuffer uncompressedDirectBuf = null;
    private int uncompressedDirectBufLen = 0;
    private ByteBuffer compressedDirectBuf = null;
    private boolean finish;
    private boolean finished;
    private long bytesRead = 0L;
    private long bytesWritten = 0L;
    private static boolean nativeLoaded;

    public static boolean isNativeLoaded() {
        return nativeLoaded;
    }

    public ZstdCompressor() {
        this.init(0x400000);
    }

    public void reinit(Configuration conf) {
        this.init(this.directBufferSize);
    }

    public ZstdCompressor(int directBufferSize) {
        this.init(directBufferSize);
    }

    private ByteBuffer realloc(ByteBuffer buf, int newSize) {
        if (buf != null) {
            if (buf.capacity() == newSize) {
                buf.clear();
                return buf;
            }
            DirectBufferPool.getInstance().release(buf);
        }
        return DirectBufferPool.getInstance().allocate(newSize);
    }

    public void releaseDirectBuffers() {
        if (this.compressedDirectBuf != null) {
            DirectBufferPool.getInstance().release(this.compressedDirectBuf);
            this.compressedDirectBuf = null;
        }
        if (this.uncompressedDirectBuf != null) {
            DirectBufferPool.getInstance().release(this.uncompressedDirectBuf);
            this.uncompressedDirectBuf = null;
        }
    }

    private void init(int directBufferSize) {
        this.directBufferSize = directBufferSize;
        int buffPlusOverhead = ZstdCompressor.compressBound(directBufferSize);
        this.uncompressedDirectBuf = this.realloc(this.uncompressedDirectBuf, directBufferSize);
        this.compressedDirectBuf = this.realloc(this.compressedDirectBuf, buffPlusOverhead);
        this.compressedDirectBuf.position(buffPlusOverhead);
        this.reset();
    }

    public synchronized void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.finished = false;
        if (len > this.uncompressedDirectBuf.remaining()) {
            this.userBuf = b;
            this.userBufOff = off;
            this.userBufLen = len;
        } else {
            this.uncompressedDirectBuf.put(b, off, len);
            this.uncompressedDirectBufLen = this.uncompressedDirectBuf.position();
        }
        this.bytesRead += (long)len;
    }

    synchronized void setInputFromSavedData() {
        if (0 >= this.userBufLen) {
            return;
        }
        this.finished = false;
        this.uncompressedDirectBufLen = Math.min(this.userBufLen, this.directBufferSize);
        this.uncompressedDirectBuf.put(this.userBuf, this.userBufOff, this.uncompressedDirectBufLen);
        this.userBufOff += this.uncompressedDirectBufLen;
        this.userBufLen -= this.uncompressedDirectBufLen;
    }

    public synchronized void setDictionary(byte[] b, int off, int len) {
    }

    public boolean needsInput() {
        return this.compressedDirectBuf.remaining() <= 0 && this.uncompressedDirectBuf.remaining() != 0 && this.userBufLen <= 0;
    }

    public synchronized void finish() {
        this.finish = true;
    }

    public synchronized boolean finished() {
        return this.finish && this.finished && this.compressedDirectBuf.remaining() == 0;
    }

    public int compressBytesDirectSpecific() {
        return this.compressBytesDirect();
    }

    public synchronized int compress(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n = this.compressedDirectBuf.remaining();
        if (n > 0) {
            n = Math.min(n, len);
            this.compressedDirectBuf.get(b, off, n);
            this.bytesWritten += (long)n;
            return n;
        }
        this.compressedDirectBuf.clear();
        this.compressedDirectBuf.limit(0);
        if (0 == this.uncompressedDirectBuf.position()) {
            this.setInputFromSavedData();
            if (0 == this.uncompressedDirectBuf.position()) {
                this.finished = true;
                return 0;
            }
        }
        n = this.compressBytesDirectSpecific();
        this.compressedDirectBuf.limit(n);
        this.uncompressedDirectBuf.clear();
        if (0 == this.userBufLen) {
            this.finished = true;
        }
        n = Math.min(n, len);
        this.bytesWritten += (long)n;
        this.compressedDirectBuf.get(b, off, n);
        return n;
    }

    public synchronized void reset() {
        this.finish = false;
        this.finished = false;
        this.uncompressedDirectBuf.clear();
        this.uncompressedDirectBufLen = 0;
        this.compressedDirectBuf.clear();
        this.compressedDirectBuf.limit(0);
        this.userBufLen = 0;
        this.userBufOff = 0;
        this.bytesWritten = 0L;
        this.bytesRead = 0L;
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.releaseDirectBuffers();
    }

    public synchronized long getBytesRead() {
        return this.bytesRead;
    }

    public synchronized long getBytesWritten() {
        return this.bytesWritten;
    }

    public byte[] uncompressedBytes() {
        byte[] b = new byte[(int)this.bytesRead];
        this.uncompressedDirectBuf.get(b);
        return b;
    }

    long getDirectBufferSize() {
        return this.directBufferSize;
    }

    public synchronized void end() {
    }

    private static native void initIDs();

    public static native int xxhash32(byte[] var0, int var1, int var2, int var3);

    public static native int compressBound(int var0);

    protected native int compressBytesDirect();

    protected native int compressBytesDirectMC();

    protected native int compressBytesDirectHC(int var1);

    static {
        if (FourMcNativeCodeLoader.isNativeCodeLoaded()) {
            try {
                ZstdCompressor.initIDs();
                nativeLoaded = true;
            }
            catch (Throwable t) {
                LOG.warn((Object)t.toString());
                nativeLoaded = false;
            }
        } else {
            LOG.error((Object)("Cannot load " + ZstdCompressor.class.getName() + " without native-hadoop library!"));
            nativeLoaded = false;
        }
    }
}

