/*
 * Decompiled with CFR 0.152.
 */
package com.fing.compression.fourmc;

import com.fing.compression.fourmc.FourMcNativeCodeLoader;
import com.fing.compression.fourmc.ZstdDecompressor;
import com.fing.compression.fourmc.ZstdUltraCompressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.BlockCompressorStream;
import org.apache.hadoop.io.compress.BlockDecompressorStream;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;

public class ZstdUltraCodec
implements Configurable,
CompressionCodec {
    private static final Log LOG = LogFactory.getLog((String)ZstdUltraCodec.class.getName());
    public static final int LZ4_BUFFER_SIZE = 0x400000;
    private Configuration conf;
    private static boolean nativeLoaded = false;

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public static boolean isNativeLoaded(Configuration conf) {
        return nativeLoaded;
    }

    public CompressionOutputStream createOutputStream(OutputStream out) throws IOException {
        return this.createOutputStream(out, this.createCompressor());
    }

    public CompressionOutputStream createOutputStream(OutputStream out, Compressor compressor) throws IOException {
        if (!ZstdUltraCodec.isNativeLoaded(this.conf)) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        int bufferPlusOverhead = ZstdUltraCompressor.compressBound(0x400000);
        return new BlockCompressorStream(out, compressor, 0x400000, bufferPlusOverhead - 0x400000);
    }

    public Class<? extends Compressor> getCompressorType() {
        if (!ZstdUltraCodec.isNativeLoaded(this.conf)) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return ZstdUltraCompressor.class;
    }

    public Compressor createCompressor() {
        assert (this.conf != null) : "Configuration cannot be null! You must call setConf() before creating a compressor.";
        if (!ZstdUltraCodec.isNativeLoaded(this.conf)) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return new ZstdUltraCompressor(0x400000);
    }

    public CompressionInputStream createInputStream(InputStream in) throws IOException {
        return this.createInputStream(in, this.createDecompressor());
    }

    public CompressionInputStream createInputStream(InputStream in, Decompressor decompressor) throws IOException {
        if (!ZstdUltraCodec.isNativeLoaded(this.conf)) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return new BlockDecompressorStream(in, decompressor, 0x400000);
    }

    public Class<? extends Decompressor> getDecompressorType() {
        if (!ZstdUltraCodec.isNativeLoaded(this.conf)) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return ZstdDecompressor.class;
    }

    public Decompressor createDecompressor() {
        if (!ZstdUltraCodec.isNativeLoaded(this.conf)) {
            throw new RuntimeException("native hadoop-4mc library not available");
        }
        return new ZstdDecompressor(0x400000);
    }

    public String getDefaultExtension() {
        return ".zstd_uc";
    }

    static {
        if (FourMcNativeCodeLoader.isNativeCodeLoaded()) {
            boolean bl = nativeLoaded = ZstdUltraCompressor.isNativeLoaded() && ZstdDecompressor.isNativeLoaded();
            if (nativeLoaded) {
                LOG.info((Object)"Successfully loaded & initialized native-4mc library");
            } else {
                LOG.error((Object)"Failed to load/initialize native-4mc library");
            }
        } else {
            LOG.error((Object)"Cannot load native-4mc without native-hadoop");
        }
    }
}

