/*
 * Decompiled with CFR 0.152.
 */
package com.fing.compression.fourmc.util;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class DirectBufferPool {
    private static DirectBufferPool instance = new DirectBufferPool();
    private HashMap<Integer, List<ByteBuffer>> poolMap = new HashMap();
    private boolean enabled = true;
    private long allocatedBuffers = 0L;
    private long usedBuffers = 0L;
    private long allocatedBytes = 0L;
    private long usedBytes = 0L;

    public static DirectBufferPool getInstance() {
        return instance;
    }

    private DirectBufferPool() {
    }

    public synchronized void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        if (this.poolMap == null) {
            this.poolMap = new HashMap();
        }
    }

    public synchronized void forceReleaseBuffers() {
        if (!this.enabled) {
            return;
        }
        this.allocatedBuffers = 0L;
        this.usedBuffers = 0L;
        this.allocatedBytes = 0L;
        this.usedBytes = 0L;
        this.poolMap.clear();
    }

    public synchronized void disable() {
        this.enabled = false;
        this.allocatedBuffers = 0L;
        this.usedBuffers = 0L;
        this.allocatedBytes = 0L;
        this.usedBytes = 0L;
        this.poolMap.clear();
        this.poolMap = null;
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public synchronized Stats getStats() {
        return new Stats(this.allocatedBuffers, this.usedBuffers, this.allocatedBytes, this.usedBytes);
    }

    public synchronized ByteBuffer allocate(int capacity) {
        if (!this.enabled) {
            return ByteBuffer.allocateDirect(capacity);
        }
        List<ByteBuffer> pool = this.poolMap.get(capacity);
        if (pool == null || pool.isEmpty()) {
            ++this.allocatedBuffers;
            this.allocatedBytes += (long)capacity;
            ++this.usedBuffers;
            this.usedBytes += (long)capacity;
            return ByteBuffer.allocateDirect(capacity);
        }
        ByteBuffer res = pool.get(0);
        pool.remove(0);
        ++this.usedBuffers;
        this.usedBytes += (long)res.capacity();
        return res;
    }

    public synchronized void release(ByteBuffer buff) {
        if (!this.enabled) {
            return;
        }
        List<ByteBuffer> pool = this.poolMap.get(buff.capacity());
        if (pool == null) {
            pool = new LinkedList<ByteBuffer>();
            this.poolMap.put(buff.capacity(), pool);
        }
        buff.clear();
        pool.add(buff);
        --this.usedBuffers;
        this.usedBytes -= (long)buff.capacity();
    }

    public static class Stats {
        public long allocatedBuffers = 0L;
        public long usedBuffers = 0L;
        public long allocatedBytes = 0L;
        public long usedBytes = 0L;

        public Stats() {
        }

        public Stats(long allocatedBuffers, long usedBuffers, long allocatedBytes, long usedBytes) {
            this.allocatedBuffers = allocatedBuffers;
            this.usedBuffers = usedBuffers;
            this.allocatedBytes = allocatedBytes;
            this.usedBytes = usedBytes;
        }
    }
}

