/*
 * Decompiled with CFR 0.152.
 */
package com.fing.compression.fourmc.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;

public class HadoopUtils {
    private static final boolean hadoopV2;
    private static final Method GET_CONFIGURATION;
    private static final String PACKAGE = "org.apache.hadoop.mapreduce";

    private static Method getMethod(String className, String methodName, Class<?> ... paramTypes) throws ClassNotFoundException, NoSuchMethodException {
        return Class.forName(className.startsWith(".") ? PACKAGE + className : className).getMethod(methodName, paramTypes);
    }

    public static boolean isVersion2x() {
        return hadoopV2;
    }

    private static Object invoke(Method method, Object obj, Object ... args) {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Can't invoke method " + method.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException("Can't invoke method " + method.getName(), e);
        }
    }

    public static Configuration getConfiguration(JobContext context) {
        return (Configuration)HadoopUtils.invoke(GET_CONFIGURATION, context, new Object[0]);
    }

    static {
        boolean v2 = true;
        try {
            Class.forName("org.apache.hadoop.mapreduce.task.JobContextImpl");
        }
        catch (ClassNotFoundException cnfe) {
            v2 = false;
        }
        hadoopV2 = v2;
        try {
            GET_CONFIGURATION = HadoopUtils.getMethod(".JobContext", "getConfiguration", new Class[0]);
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException("Can't run constructor ", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Can't find constructor ", e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Can't find class", e);
        }
    }
}

