/*
 * Decompiled with CFR 0.152.
 */
package com.fing.compression.fourmc.zstd;

import com.fing.compression.fourmc.zstd.Zstd;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.Compressor;

public class ZstdStreamCompressor
implements Compressor {
    private static final Log LOG = LogFactory.getLog((String)ZstdStreamCompressor.class.getName());
    private byte[] userBuf = null;
    private int userBufOff = 0;
    private int userBufLen = 0;
    private boolean finish;
    private boolean finished;
    private int compressionLevel;
    private long bytesRead = 0L;
    private long bytesWritten = 0L;
    private long cStream;
    private int remainingToFlush = 0;
    private static final int iBuffSize = (int)Zstd.cStreamInSize();
    private static final int oBuffSize = (int)Zstd.cStreamOutSize();
    private ByteBuffer iBuff = null;
    private int iBuffLen = 0;
    private long srcPos = 0L;
    private ByteBuffer oBuff = null;
    private int oBuffLen = 0;
    private long dstPos = 0L;
    private static boolean nativeLoaded = false;

    public static boolean isNativeLoaded() {
        return nativeLoaded;
    }

    public ZstdStreamCompressor() {
        this(1);
    }

    public ZstdStreamCompressor(int compressionLevel) {
        this.compressionLevel = compressionLevel;
        this.init();
    }

    private void init() {
        this.cStream = ZstdStreamCompressor.createCStream();
        this.iBuff = ByteBuffer.allocateDirect(iBuffSize);
        this.oBuff = ByteBuffer.allocateDirect(oBuffSize);
        this.reset();
    }

    public synchronized void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.finished = false;
        this.userBuf = b;
        this.userBufOff = off;
        this.userBufLen = len;
        this.setInputFromSavedData();
        this.oBuff.limit(oBuffSize);
        this.oBuff.position(oBuffSize);
        this.bytesRead += (long)len;
    }

    synchronized void setInputFromSavedData() {
        int len = Math.min(this.userBufLen, this.iBuff.remaining());
        this.iBuff.put(this.userBuf, this.userBufOff, len);
        this.userBufOff += len;
        this.userBufLen -= len;
        this.iBuffLen = this.iBuff.position();
    }

    public synchronized void setDictionary(byte[] b, int off, int len) {
    }

    public boolean needsInput() {
        if (this.oBuff.remaining() > 0) {
            return false;
        }
        if (this.iBuff.remaining() > 0) {
            if (this.userBufLen <= 0) {
                return true;
            }
            this.setInputFromSavedData();
            return this.iBuff.remaining() > 0;
        }
        return false;
    }

    public synchronized void finish() {
        this.finish = true;
    }

    public synchronized boolean finished() {
        return this.finish && this.finished && this.oBuff.remaining() == 0;
    }

    public synchronized int compress(byte[] b, int off, int len) throws IOException {
        boolean inputConsumedAll;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n = this.oBuff.remaining();
        if (n > 0) {
            n = Math.min(n, len);
            this.oBuff.get(b, off, n);
            this.bytesWritten += (long)n;
            return n;
        }
        if (this.remainingToFlush > 0) {
            this.oBuff.rewind();
            this.remainingToFlush = this.endStream(this.cStream, this.oBuff, 0, this.oBuff.capacity());
            if (Zstd.isError(this.remainingToFlush)) {
                throw new InternalError("Zstd endStream failed, due to: " + Zstd.getErrorName(this.remainingToFlush));
            }
            this.finished = this.remainingToFlush == 0;
            this.oBuff.limit(this.oBuffLen);
            n = Math.min(this.oBuffLen, len);
            this.bytesWritten += (long)n;
            this.oBuff.get(b, off, n);
            return n;
        }
        if (0 == this.iBuff.position()) {
            this.setInputFromSavedData();
            if (0 == this.iBuff.position()) {
                this.finished = true;
                return 0;
            }
        }
        this.oBuff.rewind();
        this.oBuff.limit(oBuffSize);
        int toRead = this.compressStream(this.cStream, this.oBuff, oBuffSize, this.iBuff, this.iBuffLen);
        if (Zstd.isError(toRead)) {
            throw new InternalError("ZSTD compressStream failed, due to: " + Zstd.getErrorName(toRead));
        }
        boolean bl = inputConsumedAll = this.srcPos >= (long)this.iBuffLen;
        if (inputConsumedAll) {
            this.iBuff.clear();
            this.srcPos = 0L;
            this.iBuffLen = 0;
        }
        if (this.finish && this.userBufLen <= 0 && inputConsumedAll) {
            int oBuffOffset = this.oBuffLen;
            this.remainingToFlush = this.endStream(this.cStream, this.oBuff, oBuffOffset, this.oBuff.capacity() - oBuffOffset);
            if (Zstd.isError(this.remainingToFlush)) {
                throw new InternalError("Zstd endStream failed, due to: " + Zstd.getErrorName(this.remainingToFlush));
            }
            this.finished = this.remainingToFlush == 0;
        }
        this.oBuff.limit(this.oBuffLen);
        n = Math.min(this.oBuffLen, len);
        this.bytesWritten += (long)n;
        this.oBuff.get(b, off, n);
        return n;
    }

    public synchronized void reset() {
        this.finish = false;
        this.finished = false;
        this.userBufLen = 0;
        this.userBufOff = 0;
        this.dstPos = 0L;
        this.srcPos = 0L;
        int r = ZstdStreamCompressor.initCStream(this.cStream, this.compressionLevel);
        if (Zstd.isError(r)) {
            LOG.error((Object)("CompressInit failed! Error is:" + Zstd.getErrorName(r)));
        }
    }

    public synchronized long getBytesRead() {
        return this.bytesRead;
    }

    public synchronized long getBytesWritten() {
        return this.bytesWritten;
    }

    public synchronized void end() {
        ZstdStreamCompressor.freeCStream(this.cStream);
    }

    public void reinit(Configuration configuration) {
        this.reset();
    }

    private static native void initIDs();

    private static native long createCStream();

    private static native int freeCStream(long var0);

    private static native int initCStream(long var0, int var2);

    private native int compressStream(long var1, ByteBuffer var3, int var4, ByteBuffer var5, int var6);

    private native int endStream(long var1, ByteBuffer var3, int var4, int var5);

    static {
        try {
            if (Zstd.isNativeLoaded()) {
                ZstdStreamCompressor.initIDs();
                nativeLoaded = true;
            }
        }
        catch (Throwable t) {
            nativeLoaded = false;
            LOG.error((Object)t);
        }
    }
}

