/*
 * Decompiled with CFR 0.152.
 */
package com.fing.compression.fourmc.zstd;

import com.fing.compression.fourmc.zstd.Zstd;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.compress.Decompressor;

public class ZstdStreamDecompressor
implements Decompressor {
    private static final Log LOG = LogFactory.getLog((String)ZstdStreamDecompressor.class.getName());
    private byte[] userBuf = null;
    private int userBufOff = 0;
    private int userBufLen = 0;
    private boolean finished;
    private long dStream = ZstdStreamDecompressor.createDStream();
    private static final int frameHeaderSizePrefix = 5;
    private static final int iBuffSize = (int)Zstd.dStreamInSize();
    private static final int oBuffSize = (int)Zstd.dStreamOutSize();
    private ByteBuffer iBuff = ByteBuffer.allocateDirect(iBuffSize);
    private int iBuffLen = 0;
    private long srcPos = 0L;
    private ByteBuffer oBuff = ByteBuffer.allocateDirect(oBuffSize);
    private int oBuffLen = 0;
    private long dstPos = 0L;
    private int toRead;
    private static boolean nativeLoaded = false;

    public static boolean isNativeLoaded() {
        return nativeLoaded;
    }

    public ZstdStreamDecompressor() {
        this.reset();
    }

    public synchronized void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.userBuf = b;
        this.userBufOff = off;
        this.userBufLen = len;
        this.setInputFromSavedData();
        this.oBuff.limit(oBuffSize);
        this.oBuff.position(oBuffSize);
    }

    synchronized void setInputFromSavedData() {
        int len = Math.min(this.userBufLen, this.toRead - this.iBuff.position());
        this.iBuff.put(this.userBuf, this.userBufOff, len);
        this.userBufOff += len;
        this.userBufLen -= len;
        this.iBuffLen = this.iBuff.position();
    }

    public synchronized void setDictionary(byte[] b, int off, int len) {
    }

    public synchronized boolean needsInput() {
        if (this.oBuff.remaining() > 0) {
            return false;
        }
        if (this.iBuffLen < this.toRead) {
            if (this.userBufLen <= 0) {
                return true;
            }
            this.setInputFromSavedData();
        }
        return false;
    }

    public synchronized boolean needsDictionary() {
        return false;
    }

    public synchronized boolean finished() {
        return this.finished && this.oBuff.remaining() == 0;
    }

    public synchronized int decompress(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int numBytes = 0;
        numBytes = this.oBuff.remaining();
        if (numBytes > 0) {
            numBytes = Math.min(numBytes, len);
            this.oBuff.get(b, off, numBytes);
            return numBytes;
        }
        if (this.srcPos < (long)this.iBuffLen || this.iBuffLen == this.toRead && !this.finished) {
            this.oBuff.rewind();
            this.oBuff.limit(oBuffSize);
            this.dstPos = 0L;
            this.toRead = this.decompressStream(this.dStream, this.oBuff, oBuffSize, this.iBuff, this.iBuffLen);
            if (Zstd.isError(this.toRead)) {
                throw new InternalError("ZSTD decompressStream failed, due to: " + Zstd.getErrorName(this.toRead));
            }
            boolean bl = this.finished = this.toRead == 0;
            if (this.srcPos >= (long)this.iBuffLen) {
                this.srcPos = 0L;
                this.iBuffLen = 0;
                this.iBuff.clear();
                this.toRead = this.toRead == 1 && this.dstPos != 0L ? 0 : this.toRead;
            }
            this.toRead = Math.min(this.toRead, iBuffSize);
            numBytes = this.oBuffLen;
            this.oBuff.limit(numBytes);
            numBytes = Math.min(numBytes, len);
            this.oBuff.get(b, off, numBytes);
        }
        return numBytes;
    }

    public synchronized int getRemaining() {
        return this.userBufLen;
    }

    public synchronized void reset() {
        this.finished = false;
        this.iBuffLen = 0;
        this.oBuff.limit(oBuffSize);
        this.oBuff.position(oBuffSize);
        this.userBufLen = 0;
        this.userBufOff = 0;
        this.toRead = ZstdStreamDecompressor.initDStream(this.dStream);
        if (Zstd.isError(this.toRead)) {
            LOG.error((Object)("InitDStream failed! Error is: " + Zstd.getErrorName(this.toRead)));
        }
        if (this.toRead == 0) {
            this.toRead = 5;
        }
    }

    public synchronized void end() {
        ZstdStreamDecompressor.freeDStream(this.dStream);
    }

    private static native void initIDs();

    private static native long createDStream();

    private static native int freeDStream(long var0);

    private static native int initDStream(long var0);

    private native int decompressStream(long var1, ByteBuffer var3, int var4, ByteBuffer var5, int var6);

    static {
        try {
            if (Zstd.isNativeLoaded()) {
                ZstdStreamDecompressor.initIDs();
                nativeLoaded = true;
            }
        }
        catch (Throwable t) {
            nativeLoaded = false;
            LOG.error((Object)t);
        }
    }
}

