/*
 * Decompiled with CFR 0.152.
 */
package com.fing.mapreduce;

import com.fing.compression.fourmc.FourMcInputFormatUtil;
import com.fing.compression.fourmc.FourMzBlockIndex;
import com.fing.compression.fourmc.util.HadoopUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public abstract class FourMzInputFormat<K, V>
extends FileInputFormat<K, V> {
    private static final Log LOG = LogFactory.getLog((String)FourMzInputFormat.class.getName());
    private final PathFilter hiddenPathFilter = new PathFilter(){

        public boolean accept(Path path) {
            String name = path.getName();
            return !name.startsWith(".") && !name.startsWith("_");
        }
    };
    private final PathFilter visible4mcFilter = new PathFilter(){

        public boolean accept(Path path) {
            String name = path.getName();
            return !name.startsWith(".") && !name.startsWith("_") && FourMcInputFormatUtil.is4mzFile(name);
        }
    };

    protected List<FileStatus> listStatus(JobContext job) throws IOException {
        List files = super.listStatus(job);
        ArrayList<FileStatus> results = new ArrayList<FileStatus>();
        Configuration conf = HadoopUtils.getConfiguration(job);
        boolean recursive = conf.getBoolean("mapred.input.dir.recursive", false);
        for (FileStatus fileStatus : files) {
            FileSystem fs = fileStatus.getPath().getFileSystem(conf);
            this.addInputPath(results, fs, fileStatus, recursive);
        }
        LOG.debug((Object)("Total 4mz input paths to process: " + results.size()));
        return results;
    }

    protected void addInputPath(List<FileStatus> results, FileSystem fs, FileStatus pathStat, boolean recursive) throws IOException {
        Path path = pathStat.getPath();
        if (pathStat.isDir()) {
            if (recursive) {
                for (FileStatus stat : fs.listStatus(path, this.hiddenPathFilter)) {
                    this.addInputPath(results, fs, stat, recursive);
                }
            }
        } else if (this.visible4mcFilter.accept(path)) {
            results.add(pathStat);
        }
    }

    protected boolean isSplitable(JobContext context, Path filename) {
        return true;
    }

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        Configuration conf = HadoopUtils.getConfiguration(job);
        List defaultSplits = super.getSplits(job);
        ArrayList<InputSplit> result = new ArrayList<InputSplit>();
        Path prevFile = null;
        FourMzBlockIndex prevIndex = null;
        for (InputSplit genericSplit : defaultSplits) {
            FourMzBlockIndex index;
            FileSplit fileSplit = (FileSplit)genericSplit;
            Path file = fileSplit.getPath();
            FileSystem fs = file.getFileSystem(conf);
            if (file.equals(prevFile)) {
                index = prevIndex;
            } else {
                index = FourMzBlockIndex.readIndex(fs, file);
                prevFile = file;
                prevIndex = index;
            }
            if (index == null) {
                throw new IOException("BlockIndex unreadable for " + file);
            }
            if (index.isEmpty()) {
                result.add((InputSplit)fileSplit);
                continue;
            }
            long start = fileSplit.getStart();
            long end = start + fileSplit.getLength();
            long fourMcStart = index.alignSliceStartToIndex(start, end);
            long fourMcEnd = index.alignSliceEndToIndex(end, fs.getFileStatus(file).getLen());
            if (fourMcStart == -1L || fourMcEnd == -1L) continue;
            result.add((InputSplit)new FileSplit(file, fourMcStart, fourMcEnd - fourMcStart, fileSplit.getLocations()));
            LOG.debug((Object)("Added 4mz split for " + file + "[start=" + fourMcStart + ", length=" + (fourMcEnd - fourMcStart) + "]"));
        }
        return result;
    }
}

