/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client;

import com.firebase.client.CredentialStore;
import com.firebase.client.EventTarget;
import com.firebase.client.FirebaseException;
import com.firebase.client.Logger;
import com.firebase.client.RunLoop;
import com.firebase.client.core.AuthExpirationBehavior;
import com.firebase.client.core.Context;
import java.util.List;

public class Config
extends Context {
    public synchronized void setLogger(Logger logger) {
        this.assertUnfrozen();
        this.logger = logger;
    }

    public synchronized void setEventTarget(EventTarget eventTarget) {
        this.assertUnfrozen();
        this.eventTarget = eventTarget;
    }

    public synchronized void setLogLevel(Logger.Level logLevel) {
        this.assertUnfrozen();
        this.logLevel = logLevel;
    }

    public synchronized void setDebugLogComponents(List<String> debugComponents) {
        this.assertUnfrozen();
        this.setLogLevel(Logger.Level.DEBUG);
        this.loggedComponents = debugComponents;
    }

    void setRunLoop(RunLoop runLoop) {
        this.runLoop = runLoop;
    }

    synchronized void setCredentialStore(CredentialStore store) {
        this.assertUnfrozen();
        this.credentialStore = store;
    }

    public synchronized void setAuthenticationServer(String host) {
        this.assertUnfrozen();
        this.authenticationServer = host;
    }

    public synchronized void setSessionPersistenceKey(String sessionKey) {
        this.assertUnfrozen();
        if (sessionKey == null || sessionKey.isEmpty()) {
            throw new IllegalArgumentException("Session identifier is not allowed to be empty or null!");
        }
        this.persistenceKey = sessionKey;
    }

    public synchronized void enablePersistence() {
        this.assertUnfrozen();
        this.setPersistenceEnabled(true);
    }

    public synchronized void setPersistenceEnabled(boolean isEnabled) {
        this.assertUnfrozen();
        this.persistenceEnabled = isEnabled;
        if (isEnabled) {
            this.setAuthExpirationBehavior(AuthExpirationBehavior.PAUSE_WRITES_UNTIL_REAUTH);
        } else {
            this.setAuthExpirationBehavior(AuthExpirationBehavior.DEFAULT);
        }
    }

    private synchronized void setAuthExpirationBehavior(AuthExpirationBehavior behavior) {
        this.assertUnfrozen();
        this.authExpirationBehavior = behavior;
    }

    public synchronized void setPersistenceCacheSizeBytes(long cacheSizeInBytes) {
        this.assertUnfrozen();
        if (cacheSizeInBytes < 0x100000L) {
            throw new FirebaseException("The minimum cache size must be at least 1MB");
        }
        if (cacheSizeInBytes > 0x6400000L) {
            throw new FirebaseException("Firebase currently doesn't support a cache size larger than 100MB");
        }
        this.cacheSize = cacheSizeInBytes;
    }
}

