/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core;

import com.firebase.client.ChildEventListener;
import com.firebase.client.DataSnapshot;
import com.firebase.client.Firebase;
import com.firebase.client.FirebaseError;
import com.firebase.client.annotations.NotNull;
import com.firebase.client.core.EventRegistration;
import com.firebase.client.core.Repo;
import com.firebase.client.core.view.Change;
import com.firebase.client.core.view.DataEvent;
import com.firebase.client.core.view.Event;
import com.firebase.client.core.view.QuerySpec;

public class ChildEventRegistration
extends EventRegistration {
    private final Repo repo;
    private final ChildEventListener eventListener;
    private final QuerySpec spec;

    public ChildEventRegistration(@NotNull Repo repo, @NotNull ChildEventListener eventListener, @NotNull QuerySpec spec) {
        this.repo = repo;
        this.eventListener = eventListener;
        this.spec = spec;
    }

    @Override
    public boolean respondsTo(Event.EventType eventType) {
        return eventType != Event.EventType.VALUE;
    }

    public boolean equals(Object other) {
        return other instanceof ChildEventRegistration && ((ChildEventRegistration)other).eventListener.equals(this.eventListener) && ((ChildEventRegistration)other).repo.equals(this.repo) && ((ChildEventRegistration)other).spec.equals(this.spec);
    }

    public int hashCode() {
        int result = this.eventListener.hashCode();
        result = 31 * result + this.repo.hashCode();
        result = 31 * result + this.spec.hashCode();
        return result;
    }

    @Override
    public DataEvent createEvent(Change change, QuerySpec query) {
        Firebase ref = new Firebase(this.repo, query.getPath().child(change.getChildKey()));
        DataSnapshot snapshot = new DataSnapshot(ref, change.getIndexedNode());
        String prevName = change.getPrevName() != null ? change.getPrevName().asString() : null;
        return new DataEvent(change.getEventType(), this, snapshot, prevName);
    }

    @Override
    public void fireEvent(DataEvent eventData) {
        if (this.isZombied()) {
            return;
        }
        switch (eventData.getEventType()) {
            case CHILD_ADDED: {
                this.eventListener.onChildAdded(eventData.getSnapshot(), eventData.getPreviousName());
                break;
            }
            case CHILD_CHANGED: {
                this.eventListener.onChildChanged(eventData.getSnapshot(), eventData.getPreviousName());
                break;
            }
            case CHILD_MOVED: {
                this.eventListener.onChildMoved(eventData.getSnapshot(), eventData.getPreviousName());
                break;
            }
            case CHILD_REMOVED: {
                this.eventListener.onChildRemoved(eventData.getSnapshot());
                break;
            }
        }
    }

    @Override
    public void fireCancelEvent(FirebaseError error) {
        this.eventListener.onCancelled(error);
    }

    @Override
    public EventRegistration clone(QuerySpec newQuery) {
        return new ChildEventRegistration(this.repo, this.eventListener, newQuery);
    }

    @Override
    public boolean isSameListener(EventRegistration other) {
        return other instanceof ChildEventRegistration && ((ChildEventRegistration)other).eventListener.equals(this.eventListener);
    }

    @Override
    @NotNull
    public QuerySpec getQuerySpec() {
        return this.spec;
    }

    public String toString() {
        return "ChildEventRegistration";
    }

    @Override
    Repo getRepo() {
        return this.repo;
    }
}

