/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core;

import com.firebase.client.CredentialStore;
import com.firebase.client.EventTarget;
import com.firebase.client.Firebase;
import com.firebase.client.Logger;
import com.firebase.client.RunLoop;
import com.firebase.client.authentication.NoopCredentialStore;
import com.firebase.client.core.Context;
import com.firebase.client.core.Platform;
import com.firebase.client.core.ThreadInitializer;
import com.firebase.client.core.ThreadPoolEventTarget;
import com.firebase.client.core.persistence.PersistenceManager;
import com.firebase.client.utilities.DefaultLogger;
import com.firebase.client.utilities.DefaultRunLoop;
import com.firebase.client.utilities.LogWrapper;
import com.firebase.tubesock.WebSocket;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.ThreadFactory;

enum GaePlatform implements Platform
{
    INSTANCE;

    static ThreadFactory threadFactoryInstance;
    static final ThreadInitializer threadInitializerInstance;

    @Override
    public Logger newLogger(Context ctx, Logger.Level level, List<String> components) {
        return new DefaultLogger(level, components);
    }

    private static ThreadFactory getGaeThreadFactory() {
        if (threadFactoryInstance == null) {
            try {
                Class<?> c = Class.forName("com.google.appengine.api.ThreadManager");
                if (c != null) {
                    threadFactoryInstance = (ThreadFactory)c.getMethod("backgroundThreadFactory", new Class[0]).invoke(null, new Object[0]);
                }
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return threadFactoryInstance;
    }

    public static boolean isActive() {
        return GaePlatform.getGaeThreadFactory() != null;
    }

    public void initialize() {
        WebSocket.setThreadFactory((ThreadFactory)threadFactoryInstance, (com.firebase.tubesock.ThreadInitializer)new com.firebase.tubesock.ThreadInitializer(){

            public void setName(Thread thread, String s) {
                threadInitializerInstance.setName(thread, s);
            }
        });
    }

    @Override
    public EventTarget newEventTarget(Context ctx) {
        return new ThreadPoolEventTarget(GaePlatform.getGaeThreadFactory(), threadInitializerInstance);
    }

    @Override
    public RunLoop newRunLoop(Context context) {
        final LogWrapper logger = context.getLogger("RunLoop");
        return new DefaultRunLoop(){

            @Override
            public void handleException(Throwable e) {
                logger.error("Uncaught exception in Firebase runloop (" + Firebase.getSdkVersion() + "). Please report to support@firebase.com", e);
            }

            @Override
            protected ThreadFactory getThreadFactory() {
                return threadFactoryInstance;
            }

            @Override
            protected ThreadInitializer getThreadInitializer() {
                return threadInitializerInstance;
            }
        };
    }

    @Override
    public String getUserAgent(Context ctx) {
        String deviceName = "AppEngine";
        String systemVersion = System.getProperty("java.specification.version", "Unknown");
        return systemVersion + "/" + deviceName;
    }

    @Override
    public String getPlatformVersion() {
        return "gae-" + Firebase.getSdkVersion();
    }

    @Override
    public PersistenceManager createPersistenceManager(Context ctx, String namespace) {
        return null;
    }

    @Override
    public CredentialStore newCredentialStore(Context ctx) {
        return new NoopCredentialStore(ctx);
    }

    @Override
    public void runBackgroundTask(final Context ctx, final Runnable r) {
        threadFactoryInstance.newThread(new Runnable(){

            @Override
            public void run() {
                try {
                    r.run();
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (Throwable e) {
                    ctx.getLogger("BackgroundTask").error("An unexpected error occurred. Please contact support@firebase.com. Details: ", e);
                    throw new RuntimeException(e);
                }
            }
        }).start();
    }

    static {
        threadInitializerInstance = new ThreadInitializer(){

            @Override
            public void setName(Thread t, String name) {
            }

            @Override
            public void setDaemon(Thread t, boolean isDaemon) {
            }

            @Override
            public void setUncaughtExceptionHandler(Thread t, Thread.UncaughtExceptionHandler handler) {
                t.setUncaughtExceptionHandler(handler);
            }
        };
    }
}

