/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core;

import com.firebase.client.core.Path;
import com.firebase.client.snapshot.ChildKey;
import com.firebase.client.snapshot.EmptyNode;
import com.firebase.client.snapshot.NamedNode;
import com.firebase.client.snapshot.Node;
import java.util.ArrayList;
import java.util.HashSet;

public class RangeMerge {
    private final Path optExclusiveStart;
    private final Path optInclusiveEnd;
    private final Node snap;

    public RangeMerge(Path optExclusiveStart, Path optInclusiveEnd, Node snap) {
        this.optExclusiveStart = optExclusiveStart;
        this.optInclusiveEnd = optInclusiveEnd;
        this.snap = snap;
    }

    public Node applyTo(Node node) {
        return this.updateRangeInNode(Path.getEmptyPath(), node, this.snap);
    }

    Path getStart() {
        return this.optExclusiveStart;
    }

    Path getEnd() {
        return this.optInclusiveEnd;
    }

    private Node updateRangeInNode(Path currentPath, Node node, Node updateNode) {
        boolean endInNode;
        int startComparison = this.optExclusiveStart == null ? 1 : currentPath.compareTo(this.optExclusiveStart);
        int endComparison = this.optInclusiveEnd == null ? -1 : currentPath.compareTo(this.optInclusiveEnd);
        boolean startInNode = this.optExclusiveStart != null && currentPath.contains(this.optExclusiveStart);
        boolean bl = endInNode = this.optInclusiveEnd != null && currentPath.contains(this.optInclusiveEnd);
        if (startComparison > 0 && endComparison < 0 && !endInNode) {
            return updateNode;
        }
        if (startComparison > 0 && endInNode && updateNode.isLeafNode()) {
            return updateNode;
        }
        if (startComparison > 0 && endComparison == 0) {
            assert (endInNode);
            assert (!updateNode.isLeafNode());
            if (node.isLeafNode()) {
                return EmptyNode.Empty();
            }
            return node;
        }
        if (startInNode || endInNode) {
            HashSet<ChildKey> allChildren = new HashSet<ChildKey>();
            for (NamedNode child : node) {
                allChildren.add(child.getName());
            }
            for (NamedNode child : updateNode) {
                allChildren.add(child.getName());
            }
            ArrayList<ChildKey> inOrder = new ArrayList<ChildKey>(allChildren.size() + 1);
            inOrder.addAll(allChildren);
            if (!updateNode.getPriority().isEmpty() || !node.getPriority().isEmpty()) {
                inOrder.add(ChildKey.getPriorityKey());
            }
            Node newNode = node;
            for (ChildKey key : inOrder) {
                Node currentChild = node.getImmediateChild(key);
                Node updatedChild = this.updateRangeInNode(currentPath.child(key), node.getImmediateChild(key), updateNode.getImmediateChild(key));
                if (updatedChild == currentChild) continue;
                newNode = newNode.updateImmediateChild(key, updatedChild);
            }
            return newNode;
        }
        assert (endComparison > 0 || startComparison <= 0);
        return node;
    }

    public String toString() {
        return "RangeMerge{optExclusiveStart=" + this.optExclusiveStart + ", optInclusiveEnd=" + this.optInclusiveEnd + ", snap=" + this.snap + '}';
    }
}

