/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core;

import java.net.URI;

public class RepoInfo {
    private static final String VERSION_PARAM = "v";
    private static final String LAST_SESSION_ID_PARAM = "ls";
    public String host;
    public boolean secure;
    public String namespace;
    public String internalHost;

    public String toString() {
        return "http" + (this.secure ? "s" : "") + "://" + this.host;
    }

    public String toDebugString() {
        return "(host=" + this.host + ", secure=" + this.secure + ", ns=" + this.namespace + " internal=" + this.internalHost + ")";
    }

    public URI getConnectionURL(String optLastSessionId) {
        String scheme = this.secure ? "wss" : "ws";
        String url = scheme + "://" + this.internalHost + "/.ws?ns=" + this.namespace + "&" + VERSION_PARAM + "=" + "5";
        if (optLastSessionId != null) {
            url = url + "&ls=" + optLastSessionId;
        }
        return URI.create(url);
    }

    public boolean isCacheableHost() {
        return this.internalHost.startsWith("s-");
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isDemoHost() {
        return this.host.contains(".firebaseio-demo.com");
    }

    public boolean isCustomHost() {
        return !this.host.contains(".firebaseio.com") && !this.host.contains(".firebaseio-demo.com");
    }
}

