/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core;

import com.firebase.client.core.CompoundWrite;
import com.firebase.client.core.Path;
import com.firebase.client.core.SnapshotHolder;
import com.firebase.client.core.SparseSnapshotTree;
import com.firebase.client.snapshot.ChildKey;
import com.firebase.client.snapshot.ChildrenNode;
import com.firebase.client.snapshot.Node;
import com.firebase.client.snapshot.NodeUtilities;
import com.firebase.client.snapshot.PriorityUtilities;
import com.firebase.client.utilities.Clock;
import java.util.HashMap;
import java.util.Map;

public class ServerValues {
    public static final String NAME_SUBKEY_SERVERVALUE = ".sv";

    public static Map<String, Object> generateServerValues(Clock clock) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("timestamp", clock.millis());
        return values;
    }

    public static Object resolveDeferredValue(Object value, Map<String, Object> serverValues) {
        String serverValueKey;
        Map mapValue;
        if (value instanceof Map && (mapValue = (Map)value).containsKey(NAME_SUBKEY_SERVERVALUE) && serverValues.containsKey(serverValueKey = (String)mapValue.get(NAME_SUBKEY_SERVERVALUE))) {
            return serverValues.get(serverValueKey);
        }
        return value;
    }

    public static SparseSnapshotTree resolveDeferredValueTree(SparseSnapshotTree tree, final Map<String, Object> serverValues) {
        final SparseSnapshotTree resolvedTree = new SparseSnapshotTree();
        tree.forEachTree(new Path(""), new SparseSnapshotTree.SparseSnapshotTreeVisitor(){

            @Override
            public void visitTree(Path prefixPath, Node tree) {
                resolvedTree.remember(prefixPath, ServerValues.resolveDeferredValueSnapshot(tree, serverValues));
            }
        });
        return resolvedTree;
    }

    public static Node resolveDeferredValueSnapshot(Node data, final Map<String, Object> serverValues) {
        Map priorityMapValue;
        Object priorityVal = data.getPriority().getValue();
        if (priorityVal instanceof Map && (priorityMapValue = (Map)priorityVal).containsKey(NAME_SUBKEY_SERVERVALUE)) {
            String serverValueKey = (String)priorityMapValue.get(NAME_SUBKEY_SERVERVALUE);
            priorityVal = serverValues.get(serverValueKey);
        }
        Node priority = PriorityUtilities.parsePriority(priorityVal);
        if (data.isLeafNode()) {
            Object value = ServerValues.resolveDeferredValue(data.getValue(), serverValues);
            if (!value.equals(data.getValue()) || !priority.equals(data.getPriority())) {
                return NodeUtilities.NodeFromJSON(value, priority);
            }
            return data;
        }
        if (data.isEmpty()) {
            return data;
        }
        ChildrenNode childNode = (ChildrenNode)data;
        final SnapshotHolder holder = new SnapshotHolder(childNode);
        childNode.forEachChild(new ChildrenNode.ChildVisitor(){

            @Override
            public void visitChild(ChildKey name, Node child) {
                Node newChildNode = ServerValues.resolveDeferredValueSnapshot(child, serverValues);
                if (newChildNode != child) {
                    holder.update(new Path(name.asString()), newChildNode);
                }
            }
        });
        if (!holder.getRootNode().getPriority().equals(priority)) {
            return holder.getRootNode().updatePriority(priority);
        }
        return holder.getRootNode();
    }

    public static CompoundWrite resolveDeferredValueMerge(CompoundWrite merge, Map<String, Object> serverValues) {
        CompoundWrite write = CompoundWrite.emptyWrite();
        for (Map.Entry<Path, Node> entry : merge) {
            write = write.addWrite(entry.getKey(), ServerValues.resolveDeferredValueSnapshot(entry.getValue(), serverValues));
        }
        return write;
    }
}

