/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core;

import com.firebase.client.DataSnapshot;
import com.firebase.client.Firebase;
import com.firebase.client.FirebaseError;
import com.firebase.client.ValueEventListener;
import com.firebase.client.annotations.NotNull;
import com.firebase.client.core.EventRegistration;
import com.firebase.client.core.Repo;
import com.firebase.client.core.view.Change;
import com.firebase.client.core.view.DataEvent;
import com.firebase.client.core.view.Event;
import com.firebase.client.core.view.QuerySpec;

public class ValueEventRegistration
extends EventRegistration {
    private final Repo repo;
    private final ValueEventListener eventListener;
    private final QuerySpec spec;

    public ValueEventRegistration(Repo repo, ValueEventListener eventListener, @NotNull QuerySpec spec) {
        this.repo = repo;
        this.eventListener = eventListener;
        this.spec = spec;
    }

    @Override
    public boolean respondsTo(Event.EventType eventType) {
        return eventType == Event.EventType.VALUE;
    }

    public boolean equals(Object other) {
        return other instanceof ValueEventRegistration && ((ValueEventRegistration)other).eventListener.equals(this.eventListener) && ((ValueEventRegistration)other).repo.equals(this.repo) && ((ValueEventRegistration)other).spec.equals(this.spec);
    }

    public int hashCode() {
        int result = this.eventListener.hashCode();
        result = 31 * result + this.repo.hashCode();
        result = 31 * result + this.spec.hashCode();
        return result;
    }

    @Override
    public DataEvent createEvent(Change change, QuerySpec query) {
        Firebase ref = new Firebase(this.repo, query.getPath());
        DataSnapshot dataSnapshot = new DataSnapshot(ref, change.getIndexedNode());
        return new DataEvent(Event.EventType.VALUE, this, dataSnapshot, null);
    }

    @Override
    public void fireEvent(DataEvent eventData) {
        if (this.isZombied()) {
            return;
        }
        this.eventListener.onDataChange(eventData.getSnapshot());
    }

    @Override
    public void fireCancelEvent(FirebaseError error) {
        this.eventListener.onCancelled(error);
    }

    @Override
    public EventRegistration clone(QuerySpec newQuery) {
        return new ValueEventRegistration(this.repo, this.eventListener, newQuery);
    }

    @Override
    public boolean isSameListener(EventRegistration other) {
        return other instanceof ValueEventRegistration && ((ValueEventRegistration)other).eventListener.equals(this.eventListener);
    }

    @Override
    @NotNull
    public QuerySpec getQuerySpec() {
        return this.spec;
    }

    public String toString() {
        return "ValueEventRegistration";
    }

    @Override
    Repo getRepo() {
        return this.repo;
    }
}

