/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core.view;

import com.firebase.client.FirebaseError;
import com.firebase.client.annotations.NotNull;
import com.firebase.client.annotations.Nullable;
import com.firebase.client.core.EventRegistration;
import com.firebase.client.core.Path;
import com.firebase.client.core.WriteTreeRef;
import com.firebase.client.core.operation.Operation;
import com.firebase.client.core.view.CacheNode;
import com.firebase.client.core.view.CancelEvent;
import com.firebase.client.core.view.Change;
import com.firebase.client.core.view.DataEvent;
import com.firebase.client.core.view.Event;
import com.firebase.client.core.view.EventGenerator;
import com.firebase.client.core.view.QuerySpec;
import com.firebase.client.core.view.ViewCache;
import com.firebase.client.core.view.ViewProcessor;
import com.firebase.client.core.view.filter.IndexedFilter;
import com.firebase.client.core.view.filter.NodeFilter;
import com.firebase.client.snapshot.EmptyNode;
import com.firebase.client.snapshot.IndexedNode;
import com.firebase.client.snapshot.NamedNode;
import com.firebase.client.snapshot.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class View {
    private final QuerySpec query;
    private final ViewProcessor processor;
    private ViewCache viewCache;
    private final List<EventRegistration> eventRegistrations;
    private final EventGenerator eventGenerator;

    public View(QuerySpec query, ViewCache initialViewCache) {
        this.query = query;
        IndexedFilter indexFilter = new IndexedFilter(query.getIndex());
        NodeFilter filter = query.getParams().getNodeFilter();
        this.processor = new ViewProcessor(filter);
        CacheNode initialServerCache = initialViewCache.getServerCache();
        CacheNode initialEventCache = initialViewCache.getEventCache();
        IndexedNode emptyIndexedNode = IndexedNode.from(EmptyNode.Empty(), query.getIndex());
        IndexedNode serverSnap = indexFilter.updateFullNode(emptyIndexedNode, initialServerCache.getIndexedNode(), null);
        IndexedNode eventSnap = filter.updateFullNode(emptyIndexedNode, initialEventCache.getIndexedNode(), null);
        CacheNode newServerCache = new CacheNode(serverSnap, initialServerCache.isFullyInitialized(), indexFilter.filtersNodes());
        CacheNode newEventCache = new CacheNode(eventSnap, initialEventCache.isFullyInitialized(), filter.filtersNodes());
        this.viewCache = new ViewCache(newEventCache, newServerCache);
        this.eventRegistrations = new ArrayList<EventRegistration>();
        this.eventGenerator = new EventGenerator(query);
    }

    public QuerySpec getQuery() {
        return this.query;
    }

    public Node getCompleteNode() {
        return this.viewCache.getCompleteEventSnap();
    }

    public Node getServerCache() {
        return this.viewCache.getServerCache().getNode();
    }

    public Node getEventCache() {
        return this.viewCache.getEventCache().getNode();
    }

    public Node getCompleteServerCache(Path path) {
        Node cache = this.viewCache.getCompleteServerSnap();
        if (cache != null && (this.query.loadsAllData() || !path.isEmpty() && !cache.getImmediateChild(path.getFront()).isEmpty())) {
            return cache.getChild(path);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.eventRegistrations.isEmpty();
    }

    public void addEventRegistration(@NotNull EventRegistration registration) {
        this.eventRegistrations.add(registration);
    }

    public List<Event> removeEventRegistration(@Nullable EventRegistration registration, FirebaseError cancelError) {
        List<Event> cancelEvents;
        if (cancelError != null) {
            cancelEvents = new ArrayList();
            assert (registration == null) : "A cancel should cancel all event registrations";
            Path path = this.query.getPath();
            for (EventRegistration eventRegistration : this.eventRegistrations) {
                cancelEvents.add(new CancelEvent(eventRegistration, cancelError, path));
            }
        } else {
            cancelEvents = Collections.emptyList();
        }
        if (registration != null) {
            int indexToDelete = -1;
            for (int i = 0; i < this.eventRegistrations.size(); ++i) {
                EventRegistration candidate = this.eventRegistrations.get(i);
                if (!candidate.isSameListener(registration)) continue;
                indexToDelete = i;
                if (candidate.isZombied()) break;
            }
            if (indexToDelete != -1) {
                EventRegistration deletedRegistration = this.eventRegistrations.get(indexToDelete);
                this.eventRegistrations.remove(indexToDelete);
                deletedRegistration.zombify();
            }
        } else {
            for (EventRegistration eventRegistration : this.eventRegistrations) {
                eventRegistration.zombify();
            }
            this.eventRegistrations.clear();
        }
        return cancelEvents;
    }

    public OperationResult applyOperation(Operation operation, WriteTreeRef writesCache, Node optCompleteServerCache) {
        if (operation.getType() == Operation.OperationType.Merge && operation.getSource().getQueryParams() != null) {
            assert (this.viewCache.getCompleteServerSnap() != null) : "We should always have a full cache before handling merges";
            assert (this.viewCache.getCompleteEventSnap() != null) : "Missing event cache, even though we have a server cache";
        }
        ViewCache oldViewCache = this.viewCache;
        ViewProcessor.ProcessorResult result = this.processor.applyOperation(oldViewCache, operation, writesCache, optCompleteServerCache);
        assert (result.viewCache.getServerCache().isFullyInitialized() || !oldViewCache.getServerCache().isFullyInitialized()) : "Once a server snap is complete, it should never go back";
        this.viewCache = result.viewCache;
        List<DataEvent> events = this.generateEventsForChanges(result.changes, result.viewCache.getEventCache().getIndexedNode(), null);
        return new OperationResult(events, result.changes);
    }

    public List<DataEvent> getInitialEvents(EventRegistration registration) {
        CacheNode eventSnap = this.viewCache.getEventCache();
        ArrayList<Change> initialChanges = new ArrayList<Change>();
        for (NamedNode child : eventSnap.getNode()) {
            initialChanges.add(Change.childAddedChange(child.getName(), child.getNode()));
        }
        if (eventSnap.isFullyInitialized()) {
            initialChanges.add(Change.valueChange(eventSnap.getIndexedNode()));
        }
        return this.generateEventsForChanges(initialChanges, eventSnap.getIndexedNode(), registration);
    }

    private List<DataEvent> generateEventsForChanges(List<Change> changes, IndexedNode eventCache, EventRegistration registration) {
        List<EventRegistration> registrations = registration == null ? this.eventRegistrations : Arrays.asList(registration);
        return this.eventGenerator.generateEventsForChanges(changes, eventCache, registrations);
    }

    List<EventRegistration> getEventRegistrations() {
        return this.eventRegistrations;
    }

    public static class OperationResult {
        public final List<DataEvent> events;
        public final List<Change> changes;

        public OperationResult(List<DataEvent> events, List<Change> changes) {
            this.events = events;
            this.changes = changes;
        }
    }
}

