/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.core.view.filter;

import com.firebase.client.core.view.Change;
import com.firebase.client.core.view.Event;
import com.firebase.client.snapshot.ChildKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChildChangeAccumulator {
    private final Map<ChildKey, Change> changeMap = new HashMap<ChildKey, Change>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void trackChildChange(Change change) {
        Event.EventType type = change.getEventType();
        ChildKey childKey = change.getChildKey();
        assert (type == Event.EventType.CHILD_ADDED || type == Event.EventType.CHILD_CHANGED || type == Event.EventType.CHILD_REMOVED) : "Only child changes supported for tracking";
        assert (!change.getChildKey().isPriorityChildName());
        if (this.changeMap.containsKey(childKey)) {
            Change oldChange = this.changeMap.get(childKey);
            Event.EventType oldType = oldChange.getEventType();
            if (type == Event.EventType.CHILD_ADDED && oldType == Event.EventType.CHILD_REMOVED) {
                this.changeMap.put(change.getChildKey(), Change.childChangedChange(childKey, change.getIndexedNode(), oldChange.getIndexedNode()));
                return;
            } else if (type == Event.EventType.CHILD_REMOVED && oldType == Event.EventType.CHILD_ADDED) {
                this.changeMap.remove(childKey);
                return;
            } else if (type == Event.EventType.CHILD_REMOVED && oldType == Event.EventType.CHILD_CHANGED) {
                this.changeMap.put(childKey, Change.childRemovedChange(childKey, oldChange.getOldIndexedNode()));
                return;
            } else if (type == Event.EventType.CHILD_CHANGED && oldType == Event.EventType.CHILD_ADDED) {
                this.changeMap.put(childKey, Change.childAddedChange(childKey, change.getIndexedNode()));
                return;
            } else {
                if (type != Event.EventType.CHILD_CHANGED || oldType != Event.EventType.CHILD_CHANGED) throw new IllegalStateException("Illegal combination of changes: " + change + " occurred after " + oldChange);
                this.changeMap.put(childKey, Change.childChangedChange(childKey, change.getIndexedNode(), oldChange.getOldIndexedNode()));
            }
            return;
        } else {
            this.changeMap.put(change.getChildKey(), change);
        }
    }

    public List<Change> getChanges() {
        return new ArrayList<Change>(this.changeMap.values());
    }
}

