/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.utilities;

import com.firebase.client.RunLoop;
import com.firebase.client.core.ThreadInitializer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class DefaultRunLoop
implements RunLoop {
    private ScheduledThreadPoolExecutor executor;

    protected ThreadFactory getThreadFactory() {
        return Executors.defaultThreadFactory();
    }

    protected ThreadInitializer getThreadInitializer() {
        return ThreadInitializer.defaultInstance;
    }

    public abstract void handleException(Throwable var1);

    public DefaultRunLoop() {
        int threadsInPool = 1;
        FirebaseThreadFactory threadFactory = new FirebaseThreadFactory();
        this.executor = new ScheduledThreadPoolExecutor(threadsInPool, threadFactory);
        this.executor.setKeepAliveTime(3L, TimeUnit.SECONDS);
    }

    @Override
    public void scheduleNow(final Runnable runnable) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable e) {
                    DefaultRunLoop.this.handleException(e);
                }
            }
        });
    }

    @Override
    public ScheduledFuture schedule(final Runnable runnable, long milliseconds) {
        return this.executor.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                catch (Throwable e) {
                    DefaultRunLoop.this.handleException(e);
                }
            }
        }, milliseconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() {
        this.executor.setCorePoolSize(0);
    }

    @Override
    public void restart() {
        this.executor.setCorePoolSize(1);
    }

    private class FirebaseThreadFactory
    implements ThreadFactory {
        private FirebaseThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = DefaultRunLoop.this.getThreadFactory().newThread(r);
            ThreadInitializer initializer = DefaultRunLoop.this.getThreadInitializer();
            initializer.setName(thread, "FirebaseWorker");
            initializer.setDaemon(thread, true);
            initializer.setUncaughtExceptionHandler(thread, new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    DefaultRunLoop.this.handleException(e);
                }
            });
            return thread;
        }
    }
}

