/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.client.utilities;

import com.firebase.client.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;

public class LogWrapper {
    private final Logger logger;
    private final String component;
    private final String prefix;

    private static String exceptionStacktrace(Throwable e) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        e.printStackTrace(printWriter);
        return writer.toString();
    }

    public LogWrapper(Logger logger, String component) {
        this(logger, component, null);
    }

    public LogWrapper(Logger logger, String component, String prefix) {
        this.logger = logger;
        this.component = component;
        this.prefix = prefix;
    }

    public void error(String message, Throwable e) {
        String logMsg = this.toLog(message) + "\n" + LogWrapper.exceptionStacktrace(e);
        this.logger.onLogMessage(Logger.Level.ERROR, this.component, logMsg, this.now());
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(String message, Throwable e) {
        String logMsg = this.toLog(message);
        if (e != null) {
            logMsg = logMsg + "\n" + LogWrapper.exceptionStacktrace(e);
        }
        this.logger.onLogMessage(Logger.Level.WARN, this.component, logMsg, this.now());
    }

    public void info(String message) {
        this.logger.onLogMessage(Logger.Level.INFO, this.component, this.toLog(message), this.now());
    }

    public void debug(String message) {
        this.debug(message, null);
    }

    public boolean logsDebug() {
        return this.logger.getLogLevel().ordinal() <= Logger.Level.DEBUG.ordinal();
    }

    public void debug(String message, Throwable e) {
        String logMsg = this.toLog(message);
        if (e != null) {
            logMsg = logMsg + "\n" + LogWrapper.exceptionStacktrace(e);
        }
        assert (this.logsDebug());
        this.logger.onLogMessage(Logger.Level.DEBUG, this.component, logMsg, this.now());
    }

    private long now() {
        return System.currentTimeMillis();
    }

    private String toLog(String message) {
        return this.prefix == null ? message : this.prefix + " - " + message;
    }
}

