/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.geofire;

import com.firebase.geofire.GeoLocation;
import com.firebase.geofire.GeoQueryDataEventListener;
import com.firebase.geofire.GeoQueryEventListener;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;

final class EventListenerBridge
implements GeoQueryDataEventListener {
    private final GeoQueryEventListener listener;

    public EventListenerBridge(GeoQueryEventListener listener) {
        this.listener = listener;
    }

    @Override
    public void onDataEntered(DataSnapshot dataSnapshot, GeoLocation location) {
        this.listener.onKeyEntered(dataSnapshot.getKey(), location);
    }

    @Override
    public void onDataExited(DataSnapshot dataSnapshot) {
        this.listener.onKeyExited(dataSnapshot.getKey());
    }

    @Override
    public void onDataMoved(DataSnapshot dataSnapshot, GeoLocation location) {
        this.listener.onKeyMoved(dataSnapshot.getKey(), location);
    }

    @Override
    public void onDataChanged(DataSnapshot dataSnapshot, GeoLocation location) {
    }

    @Override
    public void onGeoQueryReady() {
        this.listener.onGeoQueryReady();
    }

    @Override
    public void onGeoQueryError(DatabaseError error) {
        this.listener.onGeoQueryError(error);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventListenerBridge that = (EventListenerBridge)o;
        return this.listener.equals(that.listener);
    }

    public int hashCode() {
        return this.listener.hashCode();
    }
}

