/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.geofire;

public final class GeoLocation {
    public final double latitude;
    public final double longitude;

    public GeoLocation(double latitude, double longitude) {
        if (!GeoLocation.coordinatesValid(latitude, longitude)) {
            throw new IllegalArgumentException("Not a valid geo location: " + latitude + ", " + longitude);
        }
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public static boolean coordinatesValid(double latitude, double longitude) {
        return latitude >= -90.0 && latitude <= 90.0 && longitude >= -180.0 && longitude <= 180.0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoLocation that = (GeoLocation)o;
        if (Double.compare(that.latitude, this.latitude) != 0) {
            return false;
        }
        return Double.compare(that.longitude, this.longitude) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.latitude);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "GeoLocation(" + this.latitude + ", " + this.longitude + ")";
    }
}

