/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.geofire;

import com.firebase.geofire.EventListenerBridge;
import com.firebase.geofire.GeoFire;
import com.firebase.geofire.GeoLocation;
import com.firebase.geofire.GeoQueryDataEventListener;
import com.firebase.geofire.GeoQueryEventListener;
import com.firebase.geofire.core.GeoHash;
import com.firebase.geofire.core.GeoHashQuery;
import com.firebase.geofire.util.GeoUtils;
import com.google.firebase.database.ChildEventListener;
import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.DatabaseReference;
import com.google.firebase.database.Query;
import com.google.firebase.database.ValueEventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GeoQuery {
    private static final int KILOMETER_TO_METER = 1000;
    private final ChildEventListener childEventLister = new ChildEventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChildAdded(DataSnapshot dataSnapshot, String s) {
            GeoQuery geoQuery = GeoQuery.this;
            synchronized (geoQuery) {
                GeoQuery.this.childAdded(dataSnapshot);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChildChanged(DataSnapshot dataSnapshot, String s) {
            GeoQuery geoQuery = GeoQuery.this;
            synchronized (geoQuery) {
                GeoQuery.this.childChanged(dataSnapshot);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChildRemoved(DataSnapshot dataSnapshot) {
            GeoQuery geoQuery = GeoQuery.this;
            synchronized (geoQuery) {
                GeoQuery.this.childRemoved(dataSnapshot);
            }
        }

        public synchronized void onChildMoved(DataSnapshot dataSnapshot, String s) {
        }

        public synchronized void onCancelled(DatabaseError databaseError) {
        }
    };
    private final GeoFire geoFire;
    private final Set<GeoQueryDataEventListener> eventListeners = new HashSet<GeoQueryDataEventListener>();
    private final Map<GeoHashQuery, Query> firebaseQueries = new HashMap<GeoHashQuery, Query>();
    private final Set<GeoHashQuery> outstandingQueries = new HashSet<GeoHashQuery>();
    private final Map<String, LocationInfo> locationInfos = new HashMap<String, LocationInfo>();
    private GeoLocation center;
    private double radius;
    private Set<GeoHashQuery> queries;

    GeoQuery(GeoFire geoFire, GeoLocation center, double radius) {
        this.geoFire = geoFire;
        this.center = center;
        this.radius = radius * 1000.0;
    }

    private boolean locationIsInQuery(GeoLocation location) {
        return GeoUtils.distance(location, this.center) <= this.radius;
    }

    private void updateLocationInfo(final DataSnapshot dataSnapshot, final GeoLocation location) {
        String key = dataSnapshot.getKey();
        LocationInfo oldInfo = this.locationInfos.get(key);
        boolean isNew = oldInfo == null;
        final boolean changedLocation = oldInfo != null && !oldInfo.location.equals(location);
        boolean wasInQuery = oldInfo != null && oldInfo.inGeoQuery;
        boolean isInQuery = this.locationIsInQuery(location);
        if ((isNew || !wasInQuery) && isInQuery) {
            for (final GeoQueryDataEventListener listener : this.eventListeners) {
                this.geoFire.raiseEvent(new Runnable(){

                    @Override
                    public void run() {
                        listener.onDataEntered(dataSnapshot, location);
                    }
                });
            }
        } else if (!isNew && isInQuery) {
            for (final GeoQueryDataEventListener listener : this.eventListeners) {
                this.geoFire.raiseEvent(new Runnable(){

                    @Override
                    public void run() {
                        if (changedLocation) {
                            listener.onDataMoved(dataSnapshot, location);
                        }
                        listener.onDataChanged(dataSnapshot, location);
                    }
                });
            }
        } else if (wasInQuery && !isInQuery) {
            for (final GeoQueryDataEventListener listener : this.eventListeners) {
                this.geoFire.raiseEvent(new Runnable(){

                    @Override
                    public void run() {
                        listener.onDataExited(dataSnapshot);
                    }
                });
            }
        }
        LocationInfo newInfo = new LocationInfo(location, this.locationIsInQuery(location), dataSnapshot);
        this.locationInfos.put(key, newInfo);
    }

    private boolean geoHashQueriesContainGeoHash(GeoHash geoHash) {
        if (this.queries == null) {
            return false;
        }
        for (GeoHashQuery query : this.queries) {
            if (!query.containsGeoHash(geoHash)) continue;
            return true;
        }
        return false;
    }

    private void reset() {
        for (Map.Entry<GeoHashQuery, Query> entry : this.firebaseQueries.entrySet()) {
            entry.getValue().removeEventListener(this.childEventLister);
        }
        this.outstandingQueries.clear();
        this.firebaseQueries.clear();
        this.queries = null;
        this.locationInfos.clear();
    }

    private boolean hasListeners() {
        return !this.eventListeners.isEmpty();
    }

    private boolean canFireReady() {
        return this.outstandingQueries.isEmpty();
    }

    private void checkAndFireReady() {
        if (this.canFireReady()) {
            for (final GeoQueryDataEventListener listener : this.eventListeners) {
                this.geoFire.raiseEvent(new Runnable(){

                    @Override
                    public void run() {
                        listener.onGeoQueryReady();
                    }
                });
            }
        }
    }

    private void addValueToReadyListener(Query firebase, final GeoHashQuery query) {
        firebase.addListenerForSingleValueEvent(new ValueEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onDataChange(DataSnapshot dataSnapshot) {
                GeoQuery geoQuery = GeoQuery.this;
                synchronized (geoQuery) {
                    GeoQuery.this.outstandingQueries.remove(query);
                    GeoQuery.this.checkAndFireReady();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onCancelled(final DatabaseError databaseError) {
                GeoQuery geoQuery = GeoQuery.this;
                synchronized (geoQuery) {
                    for (final GeoQueryDataEventListener listener : GeoQuery.this.eventListeners) {
                        GeoQuery.this.geoFire.raiseEvent(new Runnable(){

                            @Override
                            public void run() {
                                listener.onGeoQueryError(databaseError);
                            }
                        });
                    }
                }
            }
        });
    }

    private void setupQueries() {
        Set<Object> oldQueries = this.queries == null ? new HashSet() : this.queries;
        Set<GeoHashQuery> newQueries = GeoHashQuery.queriesAtLocation(this.center, this.radius);
        this.queries = newQueries;
        for (GeoHashQuery geoHashQuery : oldQueries) {
            if (newQueries.contains(geoHashQuery)) continue;
            this.firebaseQueries.get(geoHashQuery).removeEventListener(this.childEventLister);
            this.firebaseQueries.remove(geoHashQuery);
            this.outstandingQueries.remove(geoHashQuery);
        }
        for (GeoHashQuery geoHashQuery : newQueries) {
            if (oldQueries.contains(geoHashQuery)) continue;
            this.outstandingQueries.add(geoHashQuery);
            DatabaseReference databaseReference = this.geoFire.getDatabaseReference();
            Query firebaseQuery = databaseReference.orderByChild("g").startAt(geoHashQuery.getStartValue()).endAt(geoHashQuery.getEndValue());
            firebaseQuery.addChildEventListener(this.childEventLister);
            this.addValueToReadyListener(firebaseQuery, geoHashQuery);
            this.firebaseQueries.put(geoHashQuery, firebaseQuery);
        }
        for (Map.Entry entry : this.locationInfos.entrySet()) {
            LocationInfo oldLocationInfo = (LocationInfo)entry.getValue();
            if (oldLocationInfo == null) continue;
            this.updateLocationInfo(oldLocationInfo.dataSnapshot, oldLocationInfo.location);
        }
        Iterator<Map.Entry<String, LocationInfo>> it = this.locationInfos.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, LocationInfo> entry = it.next();
            if (this.geoHashQueriesContainGeoHash(entry.getValue().geoHash)) continue;
            it.remove();
        }
        this.checkAndFireReady();
    }

    private void childAdded(DataSnapshot dataSnapshot) {
        GeoLocation location = GeoFire.getLocationValue(dataSnapshot);
        if (location == null) {
            throw new AssertionError((Object)("Got Datasnapshot without location with key " + dataSnapshot.getKey()));
        }
        this.updateLocationInfo(dataSnapshot, location);
    }

    private void childChanged(DataSnapshot dataSnapshot) {
        GeoLocation location = GeoFire.getLocationValue(dataSnapshot);
        if (location == null) {
            throw new AssertionError((Object)("Got Datasnapshot without location with key " + dataSnapshot.getKey()));
        }
        this.updateLocationInfo(dataSnapshot, location);
    }

    private void childRemoved(DataSnapshot dataSnapshot) {
        final String key = dataSnapshot.getKey();
        LocationInfo info = this.locationInfos.get(key);
        if (info != null) {
            this.geoFire.getDatabaseRefForKey(key).addListenerForSingleValueEvent(new ValueEventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onDataChange(DataSnapshot dataSnapshot) {
                    GeoQuery geoQuery = GeoQuery.this;
                    synchronized (geoQuery) {
                        LocationInfo info;
                        GeoHash hash;
                        GeoLocation location = GeoFire.getLocationValue(dataSnapshot);
                        GeoHash geoHash = hash = location != null ? new GeoHash(location) : null;
                        if ((hash == null || !GeoQuery.this.geoHashQueriesContainGeoHash(hash)) && (info = (LocationInfo)GeoQuery.this.locationInfos.remove(key)) != null && info.inGeoQuery) {
                            for (final GeoQueryDataEventListener listener : GeoQuery.this.eventListeners) {
                                GeoQuery.this.geoFire.raiseEvent(new Runnable(){

                                    @Override
                                    public void run() {
                                        listener.onDataExited(info.dataSnapshot);
                                    }
                                });
                            }
                        }
                    }
                }

                public void onCancelled(DatabaseError databaseError) {
                }
            });
        }
    }

    public synchronized void addGeoQueryEventListener(GeoQueryEventListener listener) {
        this.addGeoQueryDataEventListener(new EventListenerBridge(listener));
    }

    public synchronized void addGeoQueryDataEventListener(final GeoQueryDataEventListener listener) {
        if (this.eventListeners.contains(listener)) {
            throw new IllegalArgumentException("Added the same listener twice to a GeoQuery!");
        }
        this.eventListeners.add(listener);
        if (this.queries == null) {
            this.setupQueries();
        } else {
            for (Map.Entry<String, LocationInfo> entry : this.locationInfos.entrySet()) {
                String key = entry.getKey();
                final LocationInfo info = entry.getValue();
                if (!info.inGeoQuery) continue;
                this.geoFire.raiseEvent(new Runnable(){

                    @Override
                    public void run() {
                        listener.onDataEntered(info.dataSnapshot, info.location);
                    }
                });
            }
            if (this.canFireReady()) {
                this.geoFire.raiseEvent(new Runnable(){

                    @Override
                    public void run() {
                        listener.onGeoQueryReady();
                    }
                });
            }
        }
    }

    public synchronized void removeGeoQueryEventListener(GeoQueryEventListener listener) {
        this.removeGeoQueryEventListener(new EventListenerBridge(listener));
    }

    public synchronized void removeGeoQueryEventListener(GeoQueryDataEventListener listener) {
        if (!this.eventListeners.contains(listener)) {
            throw new IllegalArgumentException("Trying to remove listener that was removed or not added!");
        }
        this.eventListeners.remove(listener);
        if (!this.hasListeners()) {
            this.reset();
        }
    }

    public synchronized void removeAllListeners() {
        this.eventListeners.clear();
        this.reset();
    }

    public synchronized GeoLocation getCenter() {
        return this.center;
    }

    public synchronized void setCenter(GeoLocation center) {
        this.center = center;
        if (this.hasListeners()) {
            this.setupQueries();
        }
    }

    public synchronized double getRadius() {
        return this.radius / 1000.0;
    }

    public synchronized void setRadius(double radius) {
        this.radius = GeoUtils.capRadius(radius) * 1000.0;
        if (this.hasListeners()) {
            this.setupQueries();
        }
    }

    public synchronized void setLocation(GeoLocation center, double radius) {
        this.center = center;
        this.radius = GeoUtils.capRadius(radius) * 1000.0;
        if (this.hasListeners()) {
            this.setupQueries();
        }
    }

    private static class LocationInfo {
        final GeoLocation location;
        final boolean inGeoQuery;
        final GeoHash geoHash;
        final DataSnapshot dataSnapshot;

        public LocationInfo(GeoLocation location, boolean inGeoQuery, DataSnapshot dataSnapshot) {
            this.location = location;
            this.inGeoQuery = inGeoQuery;
            this.geoHash = new GeoHash(location);
            this.dataSnapshot = dataSnapshot;
        }
    }
}

