/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.geofire.core;

import com.firebase.geofire.GeoLocation;
import com.firebase.geofire.util.Base32Utils;
import java.util.Locale;

public class GeoHash {
    private final String geoHash;
    private static final int DEFAULT_PRECISION = 10;
    public static final int MAX_PRECISION = 22;
    public static final int MAX_PRECISION_BITS = 110;

    public GeoHash(double latitude, double longitude) {
        this(latitude, longitude, 10);
    }

    public GeoHash(GeoLocation location) {
        this(location.latitude, location.longitude, 10);
    }

    public GeoHash(double latitude, double longitude, int precision) {
        if (precision < 1) {
            throw new IllegalArgumentException("Precision of GeoHash must be larger than zero!");
        }
        if (precision > 22) {
            throw new IllegalArgumentException("Precision of a GeoHash must be less than 23!");
        }
        if (!GeoLocation.coordinatesValid(latitude, longitude)) {
            throw new IllegalArgumentException(String.format(Locale.US, "Not valid location coordinates: [%f, %f]", latitude, longitude));
        }
        double[] longitudeRange = new double[]{-180.0, 180.0};
        double[] latitudeRange = new double[]{-90.0, 90.0};
        char[] buffer = new char[precision];
        for (int i = 0; i < precision; ++i) {
            int hashValue = 0;
            for (int j = 0; j < 5; ++j) {
                double[] range;
                double mid;
                boolean even = (i * 5 + j) % 2 == 0;
                double val = even ? longitude : latitude;
                if (val > (mid = ((range = even ? longitudeRange : latitudeRange)[0] + range[1]) / 2.0)) {
                    hashValue = (hashValue << 1) + 1;
                    range[0] = mid;
                    continue;
                }
                hashValue <<= 1;
                range[1] = mid;
            }
            buffer[i] = Base32Utils.valueToBase32Char(hashValue);
        }
        this.geoHash = new String(buffer);
    }

    public GeoHash(String hash) {
        if (hash.length() == 0 || !Base32Utils.isValidBase32String(hash)) {
            throw new IllegalArgumentException("Not a valid geoHash: " + hash);
        }
        this.geoHash = hash;
    }

    public String getGeoHashString() {
        return this.geoHash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoHash other = (GeoHash)o;
        return this.geoHash.equals(other.geoHash);
    }

    public String toString() {
        return "GeoHash{geoHash='" + this.geoHash + '\'' + '}';
    }

    public int hashCode() {
        return this.geoHash.hashCode();
    }
}

