/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.geofire.util;

import com.firebase.geofire.GeoFire;
import com.firebase.geofire.GeoLocation;

public final class GeoUtils {
    private static final double MAX_SUPPORTED_RADIUS = 8587.0;

    private GeoUtils() {
        throw new AssertionError((Object)"No instances.");
    }

    public static double distance(GeoLocation location1, GeoLocation location2) {
        return GeoUtils.distance(location1.latitude, location1.longitude, location2.latitude, location2.longitude);
    }

    public static double distance(double lat1, double long1, double lat2, double long2) {
        double radius = 6367994.65;
        double latDelta = Math.toRadians(lat1 - lat2);
        double lonDelta = Math.toRadians(long1 - long2);
        double a = Math.sin(latDelta / 2.0) * Math.sin(latDelta / 2.0) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.sin(lonDelta / 2.0) * Math.sin(lonDelta / 2.0);
        return 1.27359893E7 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
    }

    public static double distanceToLatitudeDegrees(double distance) {
        return distance / 110574.0;
    }

    public static double distanceToLongitudeDegrees(double distance, double latitude) {
        double denominator;
        double radians = Math.toRadians(latitude);
        double numerator = Math.cos(radians) * 6378137.0 * Math.PI / 180.0;
        double deltaDegrees = numerator * (denominator = 1.0 / Math.sqrt(1.0 - 0.00669447819799 * Math.sin(radians) * Math.sin(radians)));
        if (deltaDegrees < 1.0E-12) {
            return distance > 0.0 ? 360.0 : distance;
        }
        return Math.min(360.0, distance / deltaDegrees);
    }

    public static double wrapLongitude(double longitude) {
        if (longitude >= -180.0 && longitude <= 180.0) {
            return longitude;
        }
        double adjusted = longitude + 180.0;
        if (adjusted > 0.0) {
            return adjusted % 360.0 - 180.0;
        }
        return 180.0 - -adjusted % 360.0;
    }

    public static double capRadius(double radius) {
        if (radius > 8587.0) {
            GeoFire.LOGGER.warning("The radius is bigger than 8587.0 and hence we'll use that value");
            return 8587.0;
        }
        return radius;
    }
}

