/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.tubesock;

import com.firebase.tubesock.WebSocketMessage;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.List;

class MessageBuilderFactory {
    private static CharsetDecoder decoder;
    private static CharsetEncoder encoder;

    MessageBuilderFactory() {
    }

    static Builder builder(byte opcode) {
        if (opcode == 2) {
            return new BinaryBuilder();
        }
        return new TextBuilder();
    }

    static {
        Charset utf8 = Charset.forName("UTF8");
        decoder = utf8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        encoder = utf8.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.REPORT);
        encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    static class TextBuilder
    implements Builder {
        private StringBuilder builder = new StringBuilder();
        private ByteBuffer carryOver;

        TextBuilder() {
        }

        public boolean appendBytes(byte[] bytes) {
            String nextFrame = this.decodeString(bytes);
            if (nextFrame != null) {
                this.builder.append(nextFrame);
                return true;
            }
            return false;
        }

        public WebSocketMessage toMessage() {
            if (this.carryOver != null) {
                return null;
            }
            return new WebSocketMessage(this.builder.toString());
        }

        private String decodeString(byte[] bytes) {
            try {
                ByteBuffer input = ByteBuffer.wrap(bytes);
                CharBuffer buf = decoder.decode(input);
                String text = buf.toString();
                return text;
            }
            catch (CharacterCodingException e) {
                return null;
            }
        }

        private String decodeStringStreaming(byte[] bytes) {
            try {
                ByteBuffer input = this.getBuffer(bytes);
                int bufSize = (int)((float)input.remaining() * decoder.averageCharsPerByte());
                CharBuffer output = CharBuffer.allocate(bufSize);
                while (true) {
                    CoderResult result;
                    if ((result = decoder.decode(input, output, false)).isError()) {
                        return null;
                    }
                    if (result.isUnderflow()) break;
                    if (!result.isOverflow()) continue;
                    bufSize = 2 * bufSize + 1;
                    CharBuffer o = CharBuffer.allocate(bufSize);
                    output.flip();
                    o.put(output);
                    output = o;
                }
                if (input.remaining() > 0) {
                    this.carryOver = input;
                }
                CharBuffer test = CharBuffer.wrap(output);
                encoder.encode(test);
                output.flip();
                String text = output.toString();
                return text;
            }
            catch (CharacterCodingException e) {
                return null;
            }
        }

        private ByteBuffer getBuffer(byte[] bytes) {
            if (this.carryOver != null) {
                ByteBuffer buffer = ByteBuffer.allocate(bytes.length + this.carryOver.remaining());
                buffer.put(this.carryOver);
                this.carryOver = null;
                buffer.put(bytes);
                buffer.flip();
                return buffer;
            }
            return ByteBuffer.wrap(bytes);
        }
    }

    static class BinaryBuilder
    implements Builder {
        private List<byte[]> pendingBytes = new ArrayList<byte[]>();
        private int pendingByteCount = 0;

        BinaryBuilder() {
        }

        public boolean appendBytes(byte[] bytes) {
            this.pendingBytes.add(bytes);
            this.pendingByteCount += bytes.length;
            return true;
        }

        public WebSocketMessage toMessage() {
            byte[] payload = new byte[this.pendingByteCount];
            int offset = 0;
            for (int i = 0; i < this.pendingBytes.size(); ++i) {
                byte[] segment = this.pendingBytes.get(i);
                System.arraycopy(segment, 0, payload, offset, segment.length);
                offset += segment.length;
            }
            return new WebSocketMessage(payload);
        }
    }

    static interface Builder {
        public boolean appendBytes(byte[] var1);

        public WebSocketMessage toMessage();
    }
}

