/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.tubesock;

import com.firebase.tubesock.WebSocketEventHandler;
import com.firebase.tubesock.WebSocketException;
import com.firebase.tubesock.WebSocketHandshake;
import com.firebase.tubesock.WebSocketReceiver;
import com.firebase.tubesock.WebSocketWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.StrictHostnameVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocket
extends Thread {
    private static final String THREAD_BASE_NAME = "TubeSock";
    static final byte OPCODE_NONE = 0;
    static final byte OPCODE_TEXT = 1;
    static final byte OPCODE_BINARY = 2;
    static final byte OPCODE_CLOSE = 8;
    static final byte OPCODE_PING = 9;
    static final byte OPCODE_PONG = 10;
    private URI url = null;
    private WebSocketEventHandler eventHandler = null;
    private volatile boolean connected = false;
    private WebSocketReceiver receiver = null;
    private WebSocketWriter writer = null;
    private WebSocketHandshake handshake = null;

    public WebSocket(URI url) {
        this(url, null);
    }

    public WebSocket(URI url, String protocol) {
        this(url, protocol, null);
    }

    public WebSocket(URI url, String protocol, Map<String, String> extraHeaders) {
        this.url = url;
        this.handshake = new WebSocketHandshake(url, protocol, extraHeaders);
    }

    public void setEventHandler(WebSocketEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    WebSocketEventHandler getEventHandler() {
        return this.eventHandler;
    }

    public void connect() {
        if (this.connected) {
            throw new WebSocketException("already connected");
        }
        this.setName("TubeSockReader");
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Socket socket = this.createSocket();
            DataInputStream input = new DataInputStream(socket.getInputStream());
            OutputStream output = socket.getOutputStream();
            output.write(this.handshake.getHandshake());
            boolean handshakeComplete = false;
            int len = 1000;
            byte[] buffer = new byte[len];
            int pos = 0;
            ArrayList<String> handshakeLines = new ArrayList<String>();
            while (!handshakeComplete) {
                int b = input.read();
                buffer[pos] = (byte)b;
                if (buffer[++pos - 1] != 10 || buffer[pos - 2] != 13) continue;
                String line = new String(buffer, "UTF-8");
                if (line.trim().equals("")) {
                    handshakeComplete = true;
                } else {
                    handshakeLines.add(line.trim());
                }
                buffer = new byte[len];
                pos = 0;
            }
            this.handshake.verifyServerStatusLine((String)handshakeLines.get(0));
            handshakeLines.remove(0);
            HashMap<String, String> headers = new HashMap<String, String>();
            for (String line : handshakeLines) {
                String[] keyValue = line.split(": ", 2);
                headers.put(keyValue[0], keyValue[1]);
            }
            this.handshake.verifyServerHandshakeHeaders(headers);
            this.connected = true;
            this.writer = new WebSocketWriter(output, this, THREAD_BASE_NAME);
            this.writer.start();
            this.receiver = new WebSocketReceiver(input, this);
            this.eventHandler.onOpen();
            this.receiver.run();
        }
        catch (WebSocketException wse) {
            this.eventHandler.onError(wse);
        }
        catch (IOException ioe) {
            this.eventHandler.onError(new WebSocketException("error while connecting: " + ioe.getMessage(), ioe));
        }
        finally {
            this.close();
        }
    }

    public void send(String data) {
        this.send((byte)1, data.getBytes());
    }

    public void send(byte[] data) {
        this.send((byte)2, data);
    }

    void pong(byte[] data) {
        this.send((byte)10, data);
    }

    private void send(byte opcode, byte[] data) {
        if (!this.connected) {
            throw new WebSocketException("error while sending data: not connected");
        }
        try {
            this.writer.send(opcode, true, data);
        }
        catch (IOException e) {
            this.eventHandler.onError(new WebSocketException("Failed to send frame", e));
            this.close();
        }
    }

    void handleReceiverError(WebSocketException e) {
        this.eventHandler.onError(e);
        if (this.connected) {
            this.close();
        } else {
            System.err.println("close called on closed connection");
        }
    }

    public synchronized void close() {
        if (!this.connected) {
            return;
        }
        this.sendCloseHandshake();
        if (this.receiver.isRunning()) {
            this.receiver.stopit();
        }
        this.eventHandler.onClose();
    }

    private void sendCloseHandshake() {
        try {
            this.writer.stopIt();
            this.writer.send((byte)8, true, new byte[0]);
        }
        catch (IOException e) {
            this.eventHandler.onError(new WebSocketException("Failed to send close frame", e));
        }
        this.connected = false;
    }

    private Socket createSocket() {
        Socket socket;
        String scheme = this.url.getScheme();
        String host = this.url.getHost();
        int port = this.url.getPort();
        if (scheme != null && scheme.equals("ws")) {
            if (port == -1) {
                port = 80;
            }
            try {
                socket = new Socket(host, port);
            }
            catch (UnknownHostException uhe) {
                throw new WebSocketException("unknown host: " + host, uhe);
            }
            catch (IOException ioe) {
                throw new WebSocketException("error while creating socket to " + this.url, ioe);
            }
        } else if (scheme != null && scheme.equals("wss")) {
            if (port == -1) {
                port = 443;
            }
            try {
                SocketFactory factory = SSLSocketFactory.getDefault();
                socket = factory.createSocket(host, port);
                this.verifyHost((SSLSocket)socket, host);
            }
            catch (UnknownHostException uhe) {
                throw new WebSocketException("unknown host: " + host, uhe);
            }
            catch (IOException ioe) {
                throw new WebSocketException("error while creating secure socket to " + this.url, ioe);
            }
        } else {
            throw new WebSocketException("unsupported protocol: " + scheme);
        }
        return socket;
    }

    private void verifyHost(SSLSocket socket, String host) throws SSLException {
        Certificate[] certs = socket.getSession().getPeerCertificates();
        X509Certificate peerCert = (X509Certificate)certs[0];
        StrictHostnameVerifier verifier = new StrictHostnameVerifier();
        verifier.verify(host, peerCert);
    }

    public void blockClose() throws InterruptedException {
        this.writer.join();
        this.join();
    }
}

